// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class CreateSecretRequest private constructor(builder: Builder) {
    /**
     * A list of Regions and KMS keys to replicate secrets.
     */
    public val addReplicaRegions: List<ReplicaRegionType>? = builder.addReplicaRegions
    /**
     * If you include `SecretString` or `SecretBinary`, then Secrets Manager creates an initial version for the secret, and this parameter specifies the unique identifier for the new version.
     *
     * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request.
     *
     * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a `ClientRequestToken` and include it in the request.
     *
     * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value to ensure uniqueness of your versions within the specified secret.
     * + If the `ClientRequestToken` value isn't already associated with a version of the secret then a new version of the secret is created.
     * + If a version with this value already exists and the version `SecretString` and `SecretBinary` values are the same as those in the request, then the request is ignored.
     * + If a version with this value already exists and that version's `SecretString` and `SecretBinary` values are different from those in the request, then the request fails because you cannot modify an existing version. Instead, use PutSecretValue to create a new version.
     *
     * This value becomes the `VersionId` of the new version.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The description of the secret.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether to overwrite a secret with the same name in the destination Region. By default, secrets aren't overwritten.
     */
    public val forceOverwriteReplicaSecret: kotlin.Boolean? = builder.forceOverwriteReplicaSecret
    /**
     * The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt the secret value in the secret. An alias is always prefixed by `alias/`, for example `alias/aws/secretsmanager`. For more information, see [About aliases](https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html).
     *
     * To use a KMS key in a different account, use the key ARN or the alias ARN.
     *
     * If you don't specify this value, then Secrets Manager uses the key `aws/secretsmanager`. If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
     *
     * If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use `aws/secretsmanager` to encrypt the secret, and you must create and use a customer managed KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the new secret.
     *
     * The secret name can contain ASCII letters, numbers, and the following characters: /_+=.@-
     *
     * Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter.
     *
     * Either `SecretString` or `SecretBinary` must have a value, but not both.
     *
     * This parameter is not available in the Secrets Manager console.
     */
    public val secretBinary: kotlin.ByteArray? = builder.secretBinary
    /**
     * The text data to encrypt and store in this new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value.
     *
     * Either `SecretString` or `SecretBinary` must have a value, but not both.
     *
     * If you create a secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the `SecretString` parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that a Lambda rotation function can parse.
     */
    public val secretString: kotlin.String? = builder.secretString
    /**
     * A list of tags to attach to the secret. Each tag is a key and value pair of strings in a JSON text string, for example:
     *
     * `[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]`
     *
     * Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".
     *
     * If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an `Access Denied` error. For more information, see [Control access to secrets using tags](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac) and [Limit access to identities with tags that match secrets' tags](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2).
     *
     * For information about how to format a JSON parameter for the various command line tool environments, see [Using JSON for Parameters](https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json). If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.
     *
     * For tag quotas and naming restrictions, see [Service quotas for Tagging](https://docs.aws.amazon.com/general/latest/gr/arg.html#taged-reference-quotas) in the *Amazon Web Services General Reference guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.CreateSecretRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSecretRequest(")
        append("addReplicaRegions=$addReplicaRegions,")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("forceOverwriteReplicaSecret=$forceOverwriteReplicaSecret,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("secretBinary=*** Sensitive Data Redacted ***,")
        append("secretString=*** Sensitive Data Redacted ***,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addReplicaRegions?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (forceOverwriteReplicaSecret?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (secretBinary?.contentHashCode() ?: 0)
        result = 31 * result + (secretString?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSecretRequest

        if (addReplicaRegions != other.addReplicaRegions) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (forceOverwriteReplicaSecret != other.forceOverwriteReplicaSecret) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (secretBinary != null) {
            if (other.secretBinary == null) return false
            if (!secretBinary.contentEquals(other.secretBinary)) return false
        } else if (other.secretBinary != null) return false
        if (secretString != other.secretString) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.CreateSecretRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of Regions and KMS keys to replicate secrets.
         */
        public var addReplicaRegions: List<ReplicaRegionType>? = null
        /**
         * If you include `SecretString` or `SecretBinary`, then Secrets Manager creates an initial version for the secret, and this parameter specifies the unique identifier for the new version.
         *
         * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request.
         *
         * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a `ClientRequestToken` and include it in the request.
         *
         * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value to ensure uniqueness of your versions within the specified secret.
         * + If the `ClientRequestToken` value isn't already associated with a version of the secret then a new version of the secret is created.
         * + If a version with this value already exists and the version `SecretString` and `SecretBinary` values are the same as those in the request, then the request is ignored.
         * + If a version with this value already exists and that version's `SecretString` and `SecretBinary` values are different from those in the request, then the request fails because you cannot modify an existing version. Instead, use PutSecretValue to create a new version.
         *
         * This value becomes the `VersionId` of the new version.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The description of the secret.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether to overwrite a secret with the same name in the destination Region. By default, secrets aren't overwritten.
         */
        public var forceOverwriteReplicaSecret: kotlin.Boolean? = null
        /**
         * The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt the secret value in the secret. An alias is always prefixed by `alias/`, for example `alias/aws/secretsmanager`. For more information, see [About aliases](https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html).
         *
         * To use a KMS key in a different account, use the key ARN or the alias ARN.
         *
         * If you don't specify this value, then Secrets Manager uses the key `aws/secretsmanager`. If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
         *
         * If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use `aws/secretsmanager` to encrypt the secret, and you must create and use a customer managed KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the new secret.
         *
         * The secret name can contain ASCII letters, numbers, and the following characters: /_+=.@-
         *
         * Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.
         */
        public var name: kotlin.String? = null
        /**
         * The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter.
         *
         * Either `SecretString` or `SecretBinary` must have a value, but not both.
         *
         * This parameter is not available in the Secrets Manager console.
         */
        public var secretBinary: kotlin.ByteArray? = null
        /**
         * The text data to encrypt and store in this new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value.
         *
         * Either `SecretString` or `SecretBinary` must have a value, but not both.
         *
         * If you create a secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the `SecretString` parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that a Lambda rotation function can parse.
         */
        public var secretString: kotlin.String? = null
        /**
         * A list of tags to attach to the secret. Each tag is a key and value pair of strings in a JSON text string, for example:
         *
         * `[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]`
         *
         * Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".
         *
         * If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an `Access Denied` error. For more information, see [Control access to secrets using tags](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac) and [Limit access to identities with tags that match secrets' tags](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2).
         *
         * For information about how to format a JSON parameter for the various command line tool environments, see [Using JSON for Parameters](https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json). If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.
         *
         * For tag quotas and naming restrictions, see [Service quotas for Tagging](https://docs.aws.amazon.com/general/latest/gr/arg.html#taged-reference-quotas) in the *Amazon Web Services General Reference guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.CreateSecretRequest) : this() {
            this.addReplicaRegions = x.addReplicaRegions
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.forceOverwriteReplicaSecret = x.forceOverwriteReplicaSecret
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.secretBinary = x.secretBinary
            this.secretString = x.secretString
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.CreateSecretRequest = CreateSecretRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
