// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.schemas.serde

import aws.sdk.kotlin.services.schemas.model.DiscovererState
import aws.sdk.kotlin.services.schemas.model.SchemasException
import aws.sdk.kotlin.services.schemas.model.UpdateDiscovererResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class UpdateDiscovererOperationDeserializer: HttpDeserializer.NonStreaming<UpdateDiscovererResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateDiscovererResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDiscovererError(context, call, payload)
        }
        val builder = UpdateDiscovererResponse.Builder()

        if (payload != null) {
            deserializeUpdateDiscovererOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateDiscovererError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SchemasException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SchemasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDiscovererOperationBody(builder: UpdateDiscovererResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CROSSACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("CrossAccount"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DISCOVERERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DiscovererArn"))
    val DISCOVERERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DiscovererId"))
    val SOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceArn"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CROSSACCOUNT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISCOVERERARN_DESCRIPTOR)
        field(DISCOVERERID_DESCRIPTOR)
        field(SOURCEARN_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CROSSACCOUNT_DESCRIPTOR.index -> builder.crossAccount = deserializeBoolean()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DISCOVERERARN_DESCRIPTOR.index -> builder.discovererArn = deserializeString()
                DISCOVERERID_DESCRIPTOR.index -> builder.discovererId = deserializeString()
                SOURCEARN_DESCRIPTOR.index -> builder.sourceArn = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { DiscovererState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
