// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.schemas.paginators

import aws.sdk.kotlin.services.schemas.SchemasClient
import aws.sdk.kotlin.services.schemas.model.DiscovererSummary
import aws.sdk.kotlin.services.schemas.model.ListDiscoverersRequest
import aws.sdk.kotlin.services.schemas.model.ListDiscoverersResponse
import aws.sdk.kotlin.services.schemas.model.ListRegistriesRequest
import aws.sdk.kotlin.services.schemas.model.ListRegistriesResponse
import aws.sdk.kotlin.services.schemas.model.ListSchemaVersionsRequest
import aws.sdk.kotlin.services.schemas.model.ListSchemaVersionsResponse
import aws.sdk.kotlin.services.schemas.model.ListSchemasRequest
import aws.sdk.kotlin.services.schemas.model.ListSchemasResponse
import aws.sdk.kotlin.services.schemas.model.RegistrySummary
import aws.sdk.kotlin.services.schemas.model.SchemaSummary
import aws.sdk.kotlin.services.schemas.model.SchemaVersionSummary
import aws.sdk.kotlin.services.schemas.model.SearchSchemaSummary
import aws.sdk.kotlin.services.schemas.model.SearchSchemasRequest
import aws.sdk.kotlin.services.schemas.model.SearchSchemasResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDiscoverersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDiscoverersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDiscoverersResponse]
 */
public fun SchemasClient.listDiscoverersPaginated(initialRequest: ListDiscoverersRequest = ListDiscoverersRequest { }): Flow<ListDiscoverersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDiscoverersPaginated.listDiscoverers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDiscoverersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDiscoverersResponse]
 */
public fun SchemasClient.listDiscoverersPaginated(block: ListDiscoverersRequest.Builder.() -> Unit): Flow<ListDiscoverersResponse> =
    listDiscoverersPaginated(ListDiscoverersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDiscoverersPaginated]
 * to access the nested member [DiscovererSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DiscovererSummary]
 */
@JvmName("listDiscoverersResponseDiscovererSummary")
public fun Flow<ListDiscoverersResponse>.discoverers(): Flow<DiscovererSummary> =
    transform() { response ->
        response.discoverers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRegistriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRegistriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRegistriesResponse]
 */
public fun SchemasClient.listRegistriesPaginated(initialRequest: ListRegistriesRequest = ListRegistriesRequest { }): Flow<ListRegistriesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRegistriesPaginated.listRegistries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRegistriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRegistriesResponse]
 */
public fun SchemasClient.listRegistriesPaginated(block: ListRegistriesRequest.Builder.() -> Unit): Flow<ListRegistriesResponse> =
    listRegistriesPaginated(ListRegistriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRegistriesPaginated]
 * to access the nested member [RegistrySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RegistrySummary]
 */
@JvmName("listRegistriesResponseRegistrySummary")
public fun Flow<ListRegistriesResponse>.registries(): Flow<RegistrySummary> =
    transform() { response ->
        response.registries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSchemasRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemasResponse]
 */
public fun SchemasClient.listSchemasPaginated(initialRequest: ListSchemasRequest): Flow<ListSchemasResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSchemasPaginated.listSchemas(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemasResponse]
 */
public fun SchemasClient.listSchemasPaginated(block: ListSchemasRequest.Builder.() -> Unit): Flow<ListSchemasResponse> =
    listSchemasPaginated(ListSchemasRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSchemasPaginated]
 * to access the nested member [SchemaSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SchemaSummary]
 */
@JvmName("listSchemasResponseSchemaSummary")
public fun Flow<ListSchemasResponse>.schemas(): Flow<SchemaSummary> =
    transform() { response ->
        response.schemas?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSchemaVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSchemaVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemaVersionsResponse]
 */
public fun SchemasClient.listSchemaVersionsPaginated(initialRequest: ListSchemaVersionsRequest): Flow<ListSchemaVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSchemaVersionsPaginated.listSchemaVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSchemaVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemaVersionsResponse]
 */
public fun SchemasClient.listSchemaVersionsPaginated(block: ListSchemaVersionsRequest.Builder.() -> Unit): Flow<ListSchemaVersionsResponse> =
    listSchemaVersionsPaginated(ListSchemaVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSchemaVersionsPaginated]
 * to access the nested member [SchemaVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SchemaVersionSummary]
 */
@JvmName("listSchemaVersionsResponseSchemaVersionSummary")
public fun Flow<ListSchemaVersionsResponse>.schemaVersions(): Flow<SchemaVersionSummary> =
    transform() { response ->
        response.schemaVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchSchemasRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSchemasResponse]
 */
public fun SchemasClient.searchSchemasPaginated(initialRequest: SearchSchemasRequest): Flow<SearchSchemasResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchSchemasPaginated.searchSchemas(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSchemasResponse]
 */
public fun SchemasClient.searchSchemasPaginated(block: SearchSchemasRequest.Builder.() -> Unit): Flow<SearchSchemasResponse> =
    searchSchemasPaginated(SearchSchemasRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchSchemasPaginated]
 * to access the nested member [SearchSchemaSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSchemaSummary]
 */
@JvmName("searchSchemasResponseSearchSchemaSummary")
public fun Flow<SearchSchemasResponse>.schemas(): Flow<SearchSchemaSummary> =
    transform() { response ->
        response.schemas?.forEach {
            emit(it)
        }
    }
