// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.schemas

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.schemas.auth.DefaultSchemasAuthSchemeProvider
import aws.sdk.kotlin.services.schemas.auth.SchemasAuthSchemeProvider
import aws.sdk.kotlin.services.schemas.endpoints.DefaultSchemasEndpointProvider
import aws.sdk.kotlin.services.schemas.endpoints.SchemasEndpointParameters
import aws.sdk.kotlin.services.schemas.endpoints.SchemasEndpointProvider
import aws.sdk.kotlin.services.schemas.model.CreateDiscovererRequest
import aws.sdk.kotlin.services.schemas.model.CreateDiscovererResponse
import aws.sdk.kotlin.services.schemas.model.CreateRegistryRequest
import aws.sdk.kotlin.services.schemas.model.CreateRegistryResponse
import aws.sdk.kotlin.services.schemas.model.CreateSchemaRequest
import aws.sdk.kotlin.services.schemas.model.CreateSchemaResponse
import aws.sdk.kotlin.services.schemas.model.DeleteDiscovererRequest
import aws.sdk.kotlin.services.schemas.model.DeleteDiscovererResponse
import aws.sdk.kotlin.services.schemas.model.DeleteRegistryRequest
import aws.sdk.kotlin.services.schemas.model.DeleteRegistryResponse
import aws.sdk.kotlin.services.schemas.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.schemas.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.schemas.model.DeleteSchemaRequest
import aws.sdk.kotlin.services.schemas.model.DeleteSchemaResponse
import aws.sdk.kotlin.services.schemas.model.DeleteSchemaVersionRequest
import aws.sdk.kotlin.services.schemas.model.DeleteSchemaVersionResponse
import aws.sdk.kotlin.services.schemas.model.DescribeCodeBindingRequest
import aws.sdk.kotlin.services.schemas.model.DescribeCodeBindingResponse
import aws.sdk.kotlin.services.schemas.model.DescribeDiscovererRequest
import aws.sdk.kotlin.services.schemas.model.DescribeDiscovererResponse
import aws.sdk.kotlin.services.schemas.model.DescribeRegistryRequest
import aws.sdk.kotlin.services.schemas.model.DescribeRegistryResponse
import aws.sdk.kotlin.services.schemas.model.DescribeSchemaRequest
import aws.sdk.kotlin.services.schemas.model.DescribeSchemaResponse
import aws.sdk.kotlin.services.schemas.model.ExportSchemaRequest
import aws.sdk.kotlin.services.schemas.model.ExportSchemaResponse
import aws.sdk.kotlin.services.schemas.model.GetCodeBindingSourceRequest
import aws.sdk.kotlin.services.schemas.model.GetCodeBindingSourceResponse
import aws.sdk.kotlin.services.schemas.model.GetDiscoveredSchemaRequest
import aws.sdk.kotlin.services.schemas.model.GetDiscoveredSchemaResponse
import aws.sdk.kotlin.services.schemas.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.schemas.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.schemas.model.ListDiscoverersRequest
import aws.sdk.kotlin.services.schemas.model.ListDiscoverersResponse
import aws.sdk.kotlin.services.schemas.model.ListRegistriesRequest
import aws.sdk.kotlin.services.schemas.model.ListRegistriesResponse
import aws.sdk.kotlin.services.schemas.model.ListSchemaVersionsRequest
import aws.sdk.kotlin.services.schemas.model.ListSchemaVersionsResponse
import aws.sdk.kotlin.services.schemas.model.ListSchemasRequest
import aws.sdk.kotlin.services.schemas.model.ListSchemasResponse
import aws.sdk.kotlin.services.schemas.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.schemas.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.schemas.model.PutCodeBindingRequest
import aws.sdk.kotlin.services.schemas.model.PutCodeBindingResponse
import aws.sdk.kotlin.services.schemas.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.schemas.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.schemas.model.SearchSchemasRequest
import aws.sdk.kotlin.services.schemas.model.SearchSchemasResponse
import aws.sdk.kotlin.services.schemas.model.StartDiscovererRequest
import aws.sdk.kotlin.services.schemas.model.StartDiscovererResponse
import aws.sdk.kotlin.services.schemas.model.StopDiscovererRequest
import aws.sdk.kotlin.services.schemas.model.StopDiscovererResponse
import aws.sdk.kotlin.services.schemas.model.TagResourceRequest
import aws.sdk.kotlin.services.schemas.model.TagResourceResponse
import aws.sdk.kotlin.services.schemas.model.UntagResourceRequest
import aws.sdk.kotlin.services.schemas.model.UntagResourceResponse
import aws.sdk.kotlin.services.schemas.model.UpdateDiscovererRequest
import aws.sdk.kotlin.services.schemas.model.UpdateDiscovererResponse
import aws.sdk.kotlin.services.schemas.model.UpdateRegistryRequest
import aws.sdk.kotlin.services.schemas.model.UpdateRegistryResponse
import aws.sdk.kotlin.services.schemas.model.UpdateSchemaRequest
import aws.sdk.kotlin.services.schemas.model.UpdateSchemaResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "schemas"
public const val SdkVersion: String = "1.3.64"
public const val ServiceApiVersion: String = "2019-12-02"

/**
 * Amazon EventBridge Schema Registry
 */
public interface SchemasClient : SdkClient {
    /**
     * SchemasClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SchemasClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Schemas",
                "SCHEMAS",
                "schemas",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SchemasClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SchemasClient = DefaultSchemasClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SchemasEndpointProvider = builder.endpointProvider ?: DefaultSchemasEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SchemasAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSchemasAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "schemas"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SchemasEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SchemasAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a discoverer.
     */
    public suspend fun createDiscoverer(input: CreateDiscovererRequest): CreateDiscovererResponse

    /**
     * Creates a registry.
     */
    public suspend fun createRegistry(input: CreateRegistryRequest): CreateRegistryResponse

    /**
     * Creates a schema definition.
     *
     * Inactive schemas will be deleted after two years.
     */
    public suspend fun createSchema(input: CreateSchemaRequest): CreateSchemaResponse

    /**
     * Deletes a discoverer.
     */
    public suspend fun deleteDiscoverer(input: DeleteDiscovererRequest): DeleteDiscovererResponse

    /**
     * Deletes a Registry.
     */
    public suspend fun deleteRegistry(input: DeleteRegistryRequest): DeleteRegistryResponse

    /**
     * Delete the resource-based policy attached to the specified registry.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest = DeleteResourcePolicyRequest { }): DeleteResourcePolicyResponse

    /**
     * Delete a schema definition.
     */
    public suspend fun deleteSchema(input: DeleteSchemaRequest): DeleteSchemaResponse

    /**
     * Delete the schema version definition
     */
    public suspend fun deleteSchemaVersion(input: DeleteSchemaVersionRequest): DeleteSchemaVersionResponse

    /**
     * Describe the code binding URI.
     */
    public suspend fun describeCodeBinding(input: DescribeCodeBindingRequest): DescribeCodeBindingResponse

    /**
     * Describes the discoverer.
     */
    public suspend fun describeDiscoverer(input: DescribeDiscovererRequest): DescribeDiscovererResponse

    /**
     * Describes the registry.
     */
    public suspend fun describeRegistry(input: DescribeRegistryRequest): DescribeRegistryResponse

    /**
     * Retrieve the schema definition.
     */
    public suspend fun describeSchema(input: DescribeSchemaRequest): DescribeSchemaResponse

    public suspend fun exportSchema(input: ExportSchemaRequest): ExportSchemaResponse

    /**
     * Get the code binding source URI.
     */
    public suspend fun getCodeBindingSource(input: GetCodeBindingSourceRequest): GetCodeBindingSourceResponse

    /**
     * Get the discovered schema that was generated based on sampled events.
     */
    public suspend fun getDiscoveredSchema(input: GetDiscoveredSchemaRequest): GetDiscoveredSchemaResponse

    /**
     * Retrieves the resource-based policy attached to a given registry.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest = GetResourcePolicyRequest { }): GetResourcePolicyResponse

    /**
     * List the discoverers.
     */
    public suspend fun listDiscoverers(input: ListDiscoverersRequest = ListDiscoverersRequest { }): ListDiscoverersResponse

    /**
     * List the registries.
     */
    public suspend fun listRegistries(input: ListRegistriesRequest = ListRegistriesRequest { }): ListRegistriesResponse

    /**
     * Provides a list of the schema versions and related information.
     */
    public suspend fun listSchemaVersions(input: ListSchemaVersionsRequest): ListSchemaVersionsResponse

    /**
     * List the schemas.
     */
    public suspend fun listSchemas(input: ListSchemasRequest): ListSchemasResponse

    /**
     * Get tags for resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Put code binding URI
     */
    public suspend fun putCodeBinding(input: PutCodeBindingRequest): PutCodeBindingResponse

    /**
     * The name of the policy.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Search the schemas
     */
    public suspend fun searchSchemas(input: SearchSchemasRequest): SearchSchemasResponse

    /**
     * Starts the discoverer
     */
    public suspend fun startDiscoverer(input: StartDiscovererRequest): StartDiscovererResponse

    /**
     * Stops the discoverer
     */
    public suspend fun stopDiscoverer(input: StopDiscovererRequest): StopDiscovererResponse

    /**
     * Add tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the discoverer
     */
    public suspend fun updateDiscoverer(input: UpdateDiscovererRequest): UpdateDiscovererResponse

    /**
     * Updates a registry.
     */
    public suspend fun updateRegistry(input: UpdateRegistryRequest): UpdateRegistryResponse

    /**
     * Updates the schema definition
     *
     * Inactive schemas will be deleted after two years.
     */
    public suspend fun updateSchema(input: UpdateSchemaRequest): UpdateSchemaResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SchemasClient.withConfig(block: SchemasClient.Config.Builder.() -> Unit): SchemasClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSchemasClient(newConfig)
}

/**
 * Creates a discoverer.
 */
public suspend inline fun SchemasClient.createDiscoverer(crossinline block: CreateDiscovererRequest.Builder.() -> Unit): CreateDiscovererResponse = createDiscoverer(CreateDiscovererRequest.Builder().apply(block).build())

/**
 * Creates a registry.
 */
public suspend inline fun SchemasClient.createRegistry(crossinline block: CreateRegistryRequest.Builder.() -> Unit): CreateRegistryResponse = createRegistry(CreateRegistryRequest.Builder().apply(block).build())

/**
 * Creates a schema definition.
 *
 * Inactive schemas will be deleted after two years.
 */
public suspend inline fun SchemasClient.createSchema(crossinline block: CreateSchemaRequest.Builder.() -> Unit): CreateSchemaResponse = createSchema(CreateSchemaRequest.Builder().apply(block).build())

/**
 * Deletes a discoverer.
 */
public suspend inline fun SchemasClient.deleteDiscoverer(crossinline block: DeleteDiscovererRequest.Builder.() -> Unit): DeleteDiscovererResponse = deleteDiscoverer(DeleteDiscovererRequest.Builder().apply(block).build())

/**
 * Deletes a Registry.
 */
public suspend inline fun SchemasClient.deleteRegistry(crossinline block: DeleteRegistryRequest.Builder.() -> Unit): DeleteRegistryResponse = deleteRegistry(DeleteRegistryRequest.Builder().apply(block).build())

/**
 * Delete the resource-based policy attached to the specified registry.
 */
public suspend inline fun SchemasClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Delete a schema definition.
 */
public suspend inline fun SchemasClient.deleteSchema(crossinline block: DeleteSchemaRequest.Builder.() -> Unit): DeleteSchemaResponse = deleteSchema(DeleteSchemaRequest.Builder().apply(block).build())

/**
 * Delete the schema version definition
 */
public suspend inline fun SchemasClient.deleteSchemaVersion(crossinline block: DeleteSchemaVersionRequest.Builder.() -> Unit): DeleteSchemaVersionResponse = deleteSchemaVersion(DeleteSchemaVersionRequest.Builder().apply(block).build())

/**
 * Describe the code binding URI.
 */
public suspend inline fun SchemasClient.describeCodeBinding(crossinline block: DescribeCodeBindingRequest.Builder.() -> Unit): DescribeCodeBindingResponse = describeCodeBinding(DescribeCodeBindingRequest.Builder().apply(block).build())

/**
 * Describes the discoverer.
 */
public suspend inline fun SchemasClient.describeDiscoverer(crossinline block: DescribeDiscovererRequest.Builder.() -> Unit): DescribeDiscovererResponse = describeDiscoverer(DescribeDiscovererRequest.Builder().apply(block).build())

/**
 * Describes the registry.
 */
public suspend inline fun SchemasClient.describeRegistry(crossinline block: DescribeRegistryRequest.Builder.() -> Unit): DescribeRegistryResponse = describeRegistry(DescribeRegistryRequest.Builder().apply(block).build())

/**
 * Retrieve the schema definition.
 */
public suspend inline fun SchemasClient.describeSchema(crossinline block: DescribeSchemaRequest.Builder.() -> Unit): DescribeSchemaResponse = describeSchema(DescribeSchemaRequest.Builder().apply(block).build())

public suspend inline fun SchemasClient.exportSchema(crossinline block: ExportSchemaRequest.Builder.() -> Unit): ExportSchemaResponse = exportSchema(ExportSchemaRequest.Builder().apply(block).build())

/**
 * Get the code binding source URI.
 */
public suspend inline fun SchemasClient.getCodeBindingSource(crossinline block: GetCodeBindingSourceRequest.Builder.() -> Unit): GetCodeBindingSourceResponse = getCodeBindingSource(GetCodeBindingSourceRequest.Builder().apply(block).build())

/**
 * Get the discovered schema that was generated based on sampled events.
 */
public suspend inline fun SchemasClient.getDiscoveredSchema(crossinline block: GetDiscoveredSchemaRequest.Builder.() -> Unit): GetDiscoveredSchemaResponse = getDiscoveredSchema(GetDiscoveredSchemaRequest.Builder().apply(block).build())

/**
 * Retrieves the resource-based policy attached to a given registry.
 */
public suspend inline fun SchemasClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * List the discoverers.
 */
public suspend inline fun SchemasClient.listDiscoverers(crossinline block: ListDiscoverersRequest.Builder.() -> Unit): ListDiscoverersResponse = listDiscoverers(ListDiscoverersRequest.Builder().apply(block).build())

/**
 * List the registries.
 */
public suspend inline fun SchemasClient.listRegistries(crossinline block: ListRegistriesRequest.Builder.() -> Unit): ListRegistriesResponse = listRegistries(ListRegistriesRequest.Builder().apply(block).build())

/**
 * Provides a list of the schema versions and related information.
 */
public suspend inline fun SchemasClient.listSchemaVersions(crossinline block: ListSchemaVersionsRequest.Builder.() -> Unit): ListSchemaVersionsResponse = listSchemaVersions(ListSchemaVersionsRequest.Builder().apply(block).build())

/**
 * List the schemas.
 */
public suspend inline fun SchemasClient.listSchemas(crossinline block: ListSchemasRequest.Builder.() -> Unit): ListSchemasResponse = listSchemas(ListSchemasRequest.Builder().apply(block).build())

/**
 * Get tags for resource.
 */
public suspend inline fun SchemasClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Put code binding URI
 */
public suspend inline fun SchemasClient.putCodeBinding(crossinline block: PutCodeBindingRequest.Builder.() -> Unit): PutCodeBindingResponse = putCodeBinding(PutCodeBindingRequest.Builder().apply(block).build())

/**
 * The name of the policy.
 */
public suspend inline fun SchemasClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Search the schemas
 */
public suspend inline fun SchemasClient.searchSchemas(crossinline block: SearchSchemasRequest.Builder.() -> Unit): SearchSchemasResponse = searchSchemas(SearchSchemasRequest.Builder().apply(block).build())

/**
 * Starts the discoverer
 */
public suspend inline fun SchemasClient.startDiscoverer(crossinline block: StartDiscovererRequest.Builder.() -> Unit): StartDiscovererResponse = startDiscoverer(StartDiscovererRequest.Builder().apply(block).build())

/**
 * Stops the discoverer
 */
public suspend inline fun SchemasClient.stopDiscoverer(crossinline block: StopDiscovererRequest.Builder.() -> Unit): StopDiscovererResponse = stopDiscoverer(StopDiscovererRequest.Builder().apply(block).build())

/**
 * Add tags to a resource.
 */
public suspend inline fun SchemasClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a resource.
 */
public suspend inline fun SchemasClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the discoverer
 */
public suspend inline fun SchemasClient.updateDiscoverer(crossinline block: UpdateDiscovererRequest.Builder.() -> Unit): UpdateDiscovererResponse = updateDiscoverer(UpdateDiscovererRequest.Builder().apply(block).build())

/**
 * Updates a registry.
 */
public suspend inline fun SchemasClient.updateRegistry(crossinline block: UpdateRegistryRequest.Builder.() -> Unit): UpdateRegistryResponse = updateRegistry(UpdateRegistryRequest.Builder().apply(block).build())

/**
 * Updates the schema definition
 *
 * Inactive schemas will be deleted after two years.
 */
public suspend inline fun SchemasClient.updateSchema(crossinline block: UpdateSchemaRequest.Builder.() -> Unit): UpdateSchemaResponse = updateSchema(UpdateSchemaRequest.Builder().apply(block).build())
