// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.schemas.serde

import aws.sdk.kotlin.services.schemas.model.CodeGenerationStatus
import aws.sdk.kotlin.services.schemas.model.DescribeCodeBindingResponse
import aws.sdk.kotlin.services.schemas.model.SchemasException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeCodeBindingOperationDeserializer: HttpDeserializer.NonStreaming<DescribeCodeBindingResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeCodeBindingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeCodeBindingError(context, call, payload)
        }
        val builder = DescribeCodeBindingResponse.Builder()

        if (payload != null) {
            deserializeDescribeCodeBindingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeCodeBindingError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SchemasException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SchemasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCodeBindingOperationBody(builder: DescribeCodeBindingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val LASTMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModified"))
    val SCHEMAVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SchemaVersion"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(LASTMODIFIED_DESCRIPTOR)
        field(SCHEMAVERSION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.ISO_8601)
                LASTMODIFIED_DESCRIPTOR.index -> builder.lastModified = deserializeInstant(TimestampFormat.ISO_8601)
                SCHEMAVERSION_DESCRIPTOR.index -> builder.schemaVersion = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { CodeGenerationStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
