// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.schemas.waiters

import aws.sdk.kotlin.services.schemas.SchemasClient
import aws.sdk.kotlin.services.schemas.model.DescribeCodeBindingRequest
import aws.sdk.kotlin.services.schemas.model.DescribeCodeBindingResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until code binding is generated
 */
public suspend fun SchemasClient.waitUntilCodeBindingExists(request: DescribeCodeBindingRequest): Outcome<DescribeCodeBindingResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 2_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeCodeBindingRequest, DescribeCodeBindingResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "CREATE_COMPLETE"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val status = it.status?.value
            status == "CREATE_IN_PROGRESS"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "CREATE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "NotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCodeBinding(request) }
}

/**
 * Wait until code binding is generated
 */
public suspend fun SchemasClient.waitUntilCodeBindingExists(block: DescribeCodeBindingRequest.Builder.() -> Unit): Outcome<DescribeCodeBindingResponse> =
    waitUntilCodeBindingExists(DescribeCodeBindingRequest.Builder().apply(block).build())
