// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.schemas.serde

import aws.sdk.kotlin.services.schemas.model.CodeGenerationStatus
import aws.sdk.kotlin.services.schemas.model.PutCodeBindingResponse
import aws.sdk.kotlin.services.schemas.model.SchemasException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class PutCodeBindingOperationDeserializer: HttpDeserialize<PutCodeBindingResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutCodeBindingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutCodeBindingError(context, call)
        }
        val builder = PutCodeBindingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutCodeBindingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutCodeBindingError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SchemasException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "GoneException" -> GoneExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SchemasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutCodeBindingOperationBody(builder: PutCodeBindingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val LASTMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModified"))
    val SCHEMAVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SchemaVersion"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(LASTMODIFIED_DESCRIPTOR)
        field(SCHEMAVERSION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromIso8601(it) }
                LASTMODIFIED_DESCRIPTOR.index -> builder.lastModified = deserializeString().let { Instant.fromIso8601(it) }
                SCHEMAVERSION_DESCRIPTOR.index -> builder.schemaVersion = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { CodeGenerationStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
