// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler.transform

import aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow
import aws.sdk.kotlin.services.scheduler.model.ScheduleState
import aws.sdk.kotlin.services.scheduler.model.Target
import aws.sdk.kotlin.services.scheduler.model.UpdateScheduleRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class UpdateScheduleOperationSerializer: HttpSerialize<UpdateScheduleRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateScheduleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "schedules",
                "${input.name}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateScheduleOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateScheduleOperationBody(context: ExecutionContext, input: UpdateScheduleRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndDate"))
    val FLEXIBLETIMEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FlexibleTimeWindow"))
    val GROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GroupName"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyArn"))
    val SCHEDULEEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScheduleExpression"))
    val SCHEDULEEXPRESSIONTIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScheduleExpressionTimezone"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartDate"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Target"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDDATE_DESCRIPTOR)
        field(FLEXIBLETIMEWINDOW_DESCRIPTOR)
        field(GROUPNAME_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(SCHEDULEEXPRESSION_DESCRIPTOR)
        field(SCHEDULEEXPRESSIONTIMEZONE_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.endDate?.let { field(ENDDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.flexibleTimeWindow?.let { field(FLEXIBLETIMEWINDOW_DESCRIPTOR, it, ::serializeFlexibleTimeWindowDocument) }
        input.groupName?.let { field(GROUPNAME_DESCRIPTOR, it) }
        input.kmsKeyArn?.let { field(KMSKEYARN_DESCRIPTOR, it) }
        input.scheduleExpression?.let { field(SCHEDULEEXPRESSION_DESCRIPTOR, it) }
        input.scheduleExpressionTimezone?.let { field(SCHEDULEEXPRESSIONTIMEZONE_DESCRIPTOR, it) }
        input.startDate?.let { field(STARTDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.state?.let { field(STATE_DESCRIPTOR, it.value) }
        input.target?.let { field(TARGET_DESCRIPTOR, it, ::serializeTargetDocument) }
    }
    return serializer.toByteArray()
}
