// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetScheduleResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the schedule.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time at which the schedule was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The description of the schedule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence expression, invocations might stop on, or before, the `EndDate` you specify. EventBridge Scheduler ignores `EndDate` for one-time schedules.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
     */
    public val flexibleTimeWindow: aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow? = builder.flexibleTimeWindow
    /**
     * The name of the schedule group associated with this schedule.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The ARN for a customer managed KMS Key that is be used to encrypt and decrypt your data.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The time at which the schedule was last modified.
     */
    public val lastModificationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationDate
    /**
     * The name of the schedule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The expression that defines when the schedule runs. The following formats are supported.
     * + `at` expression - `at(yyyy-mm-ddThh:mm:ss)`
     * + `rate` expression - `rate(unit value)`
     * + `cron` expression - `cron(fields)`
     *
     *  You can use `at` expressions to create one-time schedules that invoke a target once, at the time and in the time zone, that you specify. You can use `rate` and `cron` expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
     *
     *  A `cron` expression consists of six fields separated by white spaces: `(minutes hours day_of_month month day_of_week year)`.
     *
     *  A `rate` expression consists of a *value* as a positive integer, and a *unit* with the following options: `minute` | `minutes` | `hour` | `hours` | `day` | `days`
     *
     *  For more information and examples, see [Schedule types on EventBridge Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html) in the *EventBridge Scheduler User Guide*.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * The timezone in which the scheduling expression is evaluated.
     */
    public val scheduleExpressionTimezone: kotlin.String? = builder.scheduleExpressionTimezone
    /**
     * The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence expression, invocations might occur on, or after, the `StartDate` you specify. EventBridge Scheduler ignores `StartDate` for one-time schedules.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * Specifies whether the schedule is enabled or disabled.
     */
    public val state: aws.sdk.kotlin.services.scheduler.model.ScheduleState? = builder.state
    /**
     * The schedule target.
     */
    public val target: aws.sdk.kotlin.services.scheduler.model.Target? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.scheduler.model.GetScheduleResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetScheduleResponse(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("endDate=$endDate,")
        append("flexibleTimeWindow=$flexibleTimeWindow,")
        append("groupName=$groupName,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("lastModificationDate=$lastModificationDate,")
        append("name=$name,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleExpressionTimezone=$scheduleExpressionTimezone,")
        append("startDate=$startDate,")
        append("state=$state,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (flexibleTimeWindow?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lastModificationDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpressionTimezone?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetScheduleResponse

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (endDate != other.endDate) return false
        if (flexibleTimeWindow != other.flexibleTimeWindow) return false
        if (groupName != other.groupName) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (lastModificationDate != other.lastModificationDate) return false
        if (name != other.name) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleExpressionTimezone != other.scheduleExpressionTimezone) return false
        if (startDate != other.startDate) return false
        if (state != other.state) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.scheduler.model.GetScheduleResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the schedule.
         */
        public var arn: kotlin.String? = null
        /**
         * The time at which the schedule was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the schedule.
         */
        public var description: kotlin.String? = null
        /**
         * The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence expression, invocations might stop on, or before, the `EndDate` you specify. EventBridge Scheduler ignores `EndDate` for one-time schedules.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
         */
        public var flexibleTimeWindow: aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow? = null
        /**
         * The name of the schedule group associated with this schedule.
         */
        public var groupName: kotlin.String? = null
        /**
         * The ARN for a customer managed KMS Key that is be used to encrypt and decrypt your data.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The time at which the schedule was last modified.
         */
        public var lastModificationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the schedule.
         */
        public var name: kotlin.String? = null
        /**
         * The expression that defines when the schedule runs. The following formats are supported.
         * + `at` expression - `at(yyyy-mm-ddThh:mm:ss)`
         * + `rate` expression - `rate(unit value)`
         * + `cron` expression - `cron(fields)`
         *
         *  You can use `at` expressions to create one-time schedules that invoke a target once, at the time and in the time zone, that you specify. You can use `rate` and `cron` expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
         *
         *  A `cron` expression consists of six fields separated by white spaces: `(minutes hours day_of_month month day_of_week year)`.
         *
         *  A `rate` expression consists of a *value* as a positive integer, and a *unit* with the following options: `minute` | `minutes` | `hour` | `hours` | `day` | `days`
         *
         *  For more information and examples, see [Schedule types on EventBridge Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html) in the *EventBridge Scheduler User Guide*.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * The timezone in which the scheduling expression is evaluated.
         */
        public var scheduleExpressionTimezone: kotlin.String? = null
        /**
         * The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence expression, invocations might occur on, or after, the `StartDate` you specify. EventBridge Scheduler ignores `StartDate` for one-time schedules.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether the schedule is enabled or disabled.
         */
        public var state: aws.sdk.kotlin.services.scheduler.model.ScheduleState? = null
        /**
         * The schedule target.
         */
        public var target: aws.sdk.kotlin.services.scheduler.model.Target? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.scheduler.model.GetScheduleResponse) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.description = x.description
            this.endDate = x.endDate
            this.flexibleTimeWindow = x.flexibleTimeWindow
            this.groupName = x.groupName
            this.kmsKeyArn = x.kmsKeyArn
            this.lastModificationDate = x.lastModificationDate
            this.name = x.name
            this.scheduleExpression = x.scheduleExpression
            this.scheduleExpressionTimezone = x.scheduleExpressionTimezone
            this.startDate = x.startDate
            this.state = x.state
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.scheduler.model.GetScheduleResponse = GetScheduleResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow] inside the given [block]
         */
        public fun flexibleTimeWindow(block: aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow.Builder.() -> kotlin.Unit) {
            this.flexibleTimeWindow = aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.Target] inside the given [block]
         */
        public fun target(block: aws.sdk.kotlin.services.scheduler.model.Target.Builder.() -> kotlin.Unit) {
            this.target = aws.sdk.kotlin.services.scheduler.model.Target.invoke(block)
        }
    }
}
