// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateScheduleRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, EventBridge Scheduler uses a randomly generated token for the request to ensure idempotency.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description you specify for the schedule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence expression, invocations might stop on, or before, the `EndDate` you specify. EventBridge Scheduler ignores `EndDate` for one-time schedules.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
     */
    public val flexibleTimeWindow: aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow? = builder.flexibleTimeWindow
    /**
     * The name of the schedule group to associate with this schedule. If you omit this, the default schedule group is used.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name of the schedule that you are creating.
     */
    public val name: kotlin.String? = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The expression that defines when the schedule runs. The following formats are supported.
     * + `at` expression - `at(yyyy-mm-ddThh:mm:ss)`
     * + `rate` expression - `rate(unit value)`
     * + `cron` expression - `cron(fields)`
     *
     *  You can use `at` expressions to create one-time schedules that invoke a target once, at the time and in the time zone, that you specify. You can use `rate` and `cron` expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
     *
     *  A `cron` expression consists of six fields separated by white spaces: `(minutes hours day_of_month month day_of_week year)`.
     *
     *  A `rate` expression consists of a *value* as a positive integer, and a *unit* with the following options: `minute` | `minutes` | `hour` | `hours` | `day` | `days`
     *
     *  For more information and examples, see [Schedule types on EventBridge Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html) in the *EventBridge Scheduler User Guide*.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * The timezone in which the scheduling expression is evaluated.
     */
    public val scheduleExpressionTimezone: kotlin.String? = builder.scheduleExpressionTimezone
    /**
     * The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence expression, invocations might occur on, or after, the `StartDate` you specify. EventBridge Scheduler ignores `StartDate` for one-time schedules.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * Specifies whether the schedule is enabled or disabled.
     */
    public val state: aws.sdk.kotlin.services.scheduler.model.ScheduleState? = builder.state
    /**
     * The schedule's target.
     */
    public val target: aws.sdk.kotlin.services.scheduler.model.Target? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.scheduler.model.CreateScheduleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateScheduleRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("endDate=$endDate,")
        append("flexibleTimeWindow=$flexibleTimeWindow,")
        append("groupName=$groupName,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleExpressionTimezone=$scheduleExpressionTimezone,")
        append("startDate=$startDate,")
        append("state=$state,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (flexibleTimeWindow?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpressionTimezone?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateScheduleRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (endDate != other.endDate) return false
        if (flexibleTimeWindow != other.flexibleTimeWindow) return false
        if (groupName != other.groupName) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleExpressionTimezone != other.scheduleExpressionTimezone) return false
        if (startDate != other.startDate) return false
        if (state != other.state) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.scheduler.model.CreateScheduleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, EventBridge Scheduler uses a randomly generated token for the request to ensure idempotency.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description you specify for the schedule.
         */
        public var description: kotlin.String? = null
        /**
         * The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence expression, invocations might stop on, or before, the `EndDate` you specify. EventBridge Scheduler ignores `EndDate` for one-time schedules.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
         */
        public var flexibleTimeWindow: aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow? = null
        /**
         * The name of the schedule group to associate with this schedule. If you omit this, the default schedule group is used.
         */
        public var groupName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The name of the schedule that you are creating.
         */
        public var name: kotlin.String? = null
        /**
         * The expression that defines when the schedule runs. The following formats are supported.
         * + `at` expression - `at(yyyy-mm-ddThh:mm:ss)`
         * + `rate` expression - `rate(unit value)`
         * + `cron` expression - `cron(fields)`
         *
         *  You can use `at` expressions to create one-time schedules that invoke a target once, at the time and in the time zone, that you specify. You can use `rate` and `cron` expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
         *
         *  A `cron` expression consists of six fields separated by white spaces: `(minutes hours day_of_month month day_of_week year)`.
         *
         *  A `rate` expression consists of a *value* as a positive integer, and a *unit* with the following options: `minute` | `minutes` | `hour` | `hours` | `day` | `days`
         *
         *  For more information and examples, see [Schedule types on EventBridge Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html) in the *EventBridge Scheduler User Guide*.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * The timezone in which the scheduling expression is evaluated.
         */
        public var scheduleExpressionTimezone: kotlin.String? = null
        /**
         * The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence expression, invocations might occur on, or after, the `StartDate` you specify. EventBridge Scheduler ignores `StartDate` for one-time schedules.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether the schedule is enabled or disabled.
         */
        public var state: aws.sdk.kotlin.services.scheduler.model.ScheduleState? = null
        /**
         * The schedule's target.
         */
        public var target: aws.sdk.kotlin.services.scheduler.model.Target? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.scheduler.model.CreateScheduleRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.endDate = x.endDate
            this.flexibleTimeWindow = x.flexibleTimeWindow
            this.groupName = x.groupName
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.scheduleExpression = x.scheduleExpression
            this.scheduleExpressionTimezone = x.scheduleExpressionTimezone
            this.startDate = x.startDate
            this.state = x.state
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.scheduler.model.CreateScheduleRequest = CreateScheduleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow] inside the given [block]
         */
        public fun flexibleTimeWindow(block: aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow.Builder.() -> kotlin.Unit) {
            this.flexibleTimeWindow = aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.Target] inside the given [block]
         */
        public fun target(block: aws.sdk.kotlin.services.scheduler.model.Target.Builder.() -> kotlin.Unit) {
            this.target = aws.sdk.kotlin.services.scheduler.model.Target.invoke(block)
        }
    }
}
