// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesSchedulerModelDeadLetterConfigDslBuilderRef = aws.sdk.kotlin.services.scheduler.model.DeadLetterConfig
private val awsSdkKotlinServicesSchedulerModelEcsParametersDslBuilderRef = aws.sdk.kotlin.services.scheduler.model.EcsParameters
private val awsSdkKotlinServicesSchedulerModelEventBridgeParametersDslBuilderRef = aws.sdk.kotlin.services.scheduler.model.EventBridgeParameters
private val awsSdkKotlinServicesSchedulerModelKinesisParametersDslBuilderRef = aws.sdk.kotlin.services.scheduler.model.KinesisParameters
private val awsSdkKotlinServicesSchedulerModelRetryPolicyDslBuilderRef = aws.sdk.kotlin.services.scheduler.model.RetryPolicy
private val awsSdkKotlinServicesSchedulerModelSageMakerPipelineParametersDslBuilderRef = aws.sdk.kotlin.services.scheduler.model.SageMakerPipelineParameters
private val awsSdkKotlinServicesSchedulerModelSqsParametersDslBuilderRef = aws.sdk.kotlin.services.scheduler.model.SqsParameters

/**
 * The schedule's target. EventBridge Scheduler supports templated target that invoke common API operations, as well as universal targets that you can customize to invoke over 6,000 API operations across more than 270 services. You can only specify one templated or universal target for a schedule.
 */
public class Target private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.
     */
    public val deadLetterConfig: aws.sdk.kotlin.services.scheduler.model.DeadLetterConfig? = builder.deadLetterConfig
    /**
     * The templated target type for the Amazon ECS `RunTask`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation.
     */
    public val ecsParameters: aws.sdk.kotlin.services.scheduler.model.EcsParameters? = builder.ecsParameters
    /**
     * The templated target type for the EventBridge `PutEvents`[](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation.
     */
    public val eventBridgeParameters: aws.sdk.kotlin.services.scheduler.model.EventBridgeParameters? = builder.eventBridgeParameters
    /**
     * The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a JSON is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default notification to the target.
     */
    public val input: kotlin.String? = builder.input
    /**
     * The templated target type for the Amazon Kinesis `PutRecord`[](kinesis/latest/APIReference/API_PutRecord.html) API operation.
     */
    public val kinesisParameters: aws.sdk.kotlin.services.scheduler.model.KinesisParameters? = builder.kinesisParameters
    /**
     * A `RetryPolicy` object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
     */
    public val retryPolicy: aws.sdk.kotlin.services.scheduler.model.RetryPolicy? = builder.retryPolicy
    /**
     * The Amazon Resource Name (ARN) of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The templated target type for the Amazon SageMaker `StartPipelineExecution`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation.
     */
    public val sageMakerPipelineParameters: aws.sdk.kotlin.services.scheduler.model.SageMakerPipelineParameters? = builder.sageMakerPipelineParameters
    /**
     * The templated target type for the Amazon SQS `SendMessage`[](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Contains the message group ID to use when the target is a FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication enabled. For more information, see [Using the Amazon SQS message deduplication ID](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html) in the *Amazon SQS Developer Guide*.
     */
    public val sqsParameters: aws.sdk.kotlin.services.scheduler.model.SqsParameters? = builder.sqsParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.scheduler.model.Target = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Target(")
        append("arn=$arn,")
        append("deadLetterConfig=$deadLetterConfig,")
        append("ecsParameters=$ecsParameters,")
        append("eventBridgeParameters=$eventBridgeParameters,")
        append("input=$input,")
        append("kinesisParameters=$kinesisParameters,")
        append("retryPolicy=$retryPolicy,")
        append("roleArn=$roleArn,")
        append("sageMakerPipelineParameters=$sageMakerPipelineParameters,")
        append("sqsParameters=$sqsParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (this.deadLetterConfig?.hashCode() ?: 0)
        result = 31 * result + (this.ecsParameters?.hashCode() ?: 0)
        result = 31 * result + (this.eventBridgeParameters?.hashCode() ?: 0)
        result = 31 * result + (this.input?.hashCode() ?: 0)
        result = 31 * result + (this.kinesisParameters?.hashCode() ?: 0)
        result = 31 * result + (this.retryPolicy?.hashCode() ?: 0)
        result = 31 * result + (this.roleArn.hashCode())
        result = 31 * result + (this.sageMakerPipelineParameters?.hashCode() ?: 0)
        result = 31 * result + (this.sqsParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Target

        if (arn != other.arn) return false
        if (deadLetterConfig != other.deadLetterConfig) return false
        if (ecsParameters != other.ecsParameters) return false
        if (eventBridgeParameters != other.eventBridgeParameters) return false
        if (input != other.input) return false
        if (kinesisParameters != other.kinesisParameters) return false
        if (retryPolicy != other.retryPolicy) return false
        if (roleArn != other.roleArn) return false
        if (sageMakerPipelineParameters != other.sageMakerPipelineParameters) return false
        if (sqsParameters != other.sqsParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.scheduler.model.Target = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        public var arn: kotlin.String? = null
        /**
         * An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.
         */
        public var deadLetterConfig: aws.sdk.kotlin.services.scheduler.model.DeadLetterConfig? = null
        /**
         * The templated target type for the Amazon ECS `RunTask`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation.
         */
        public var ecsParameters: aws.sdk.kotlin.services.scheduler.model.EcsParameters? = null
        /**
         * The templated target type for the EventBridge `PutEvents`[](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation.
         */
        public var eventBridgeParameters: aws.sdk.kotlin.services.scheduler.model.EventBridgeParameters? = null
        /**
         * The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a JSON is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default notification to the target.
         */
        public var input: kotlin.String? = null
        /**
         * The templated target type for the Amazon Kinesis `PutRecord`[](kinesis/latest/APIReference/API_PutRecord.html) API operation.
         */
        public var kinesisParameters: aws.sdk.kotlin.services.scheduler.model.KinesisParameters? = null
        /**
         * A `RetryPolicy` object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
         */
        public var retryPolicy: aws.sdk.kotlin.services.scheduler.model.RetryPolicy? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The templated target type for the Amazon SageMaker `StartPipelineExecution`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation.
         */
        public var sageMakerPipelineParameters: aws.sdk.kotlin.services.scheduler.model.SageMakerPipelineParameters? = null
        /**
         * The templated target type for the Amazon SQS `SendMessage`[](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Contains the message group ID to use when the target is a FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication enabled. For more information, see [Using the Amazon SQS message deduplication ID](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html) in the *Amazon SQS Developer Guide*.
         */
        public var sqsParameters: aws.sdk.kotlin.services.scheduler.model.SqsParameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.scheduler.model.Target) : this() {
            this.arn = x.arn
            this.deadLetterConfig = x.deadLetterConfig
            this.ecsParameters = x.ecsParameters
            this.eventBridgeParameters = x.eventBridgeParameters
            this.input = x.input
            this.kinesisParameters = x.kinesisParameters
            this.retryPolicy = x.retryPolicy
            this.roleArn = x.roleArn
            this.sageMakerPipelineParameters = x.sageMakerPipelineParameters
            this.sqsParameters = x.sqsParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.scheduler.model.Target = Target(this)

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.DeadLetterConfig] inside the given [block]
         */
        public fun deadLetterConfig(block: aws.sdk.kotlin.services.scheduler.model.DeadLetterConfig.Builder.() -> kotlin.Unit) {
            this.deadLetterConfig = awsSdkKotlinServicesSchedulerModelDeadLetterConfigDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.EcsParameters] inside the given [block]
         */
        public fun ecsParameters(block: aws.sdk.kotlin.services.scheduler.model.EcsParameters.Builder.() -> kotlin.Unit) {
            this.ecsParameters = awsSdkKotlinServicesSchedulerModelEcsParametersDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.EventBridgeParameters] inside the given [block]
         */
        public fun eventBridgeParameters(block: aws.sdk.kotlin.services.scheduler.model.EventBridgeParameters.Builder.() -> kotlin.Unit) {
            this.eventBridgeParameters = awsSdkKotlinServicesSchedulerModelEventBridgeParametersDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.KinesisParameters] inside the given [block]
         */
        public fun kinesisParameters(block: aws.sdk.kotlin.services.scheduler.model.KinesisParameters.Builder.() -> kotlin.Unit) {
            this.kinesisParameters = awsSdkKotlinServicesSchedulerModelKinesisParametersDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.RetryPolicy] inside the given [block]
         */
        public fun retryPolicy(block: aws.sdk.kotlin.services.scheduler.model.RetryPolicy.Builder.() -> kotlin.Unit) {
            this.retryPolicy = awsSdkKotlinServicesSchedulerModelRetryPolicyDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.SageMakerPipelineParameters] inside the given [block]
         */
        public fun sageMakerPipelineParameters(block: aws.sdk.kotlin.services.scheduler.model.SageMakerPipelineParameters.Builder.() -> kotlin.Unit) {
            this.sageMakerPipelineParameters = awsSdkKotlinServicesSchedulerModelSageMakerPipelineParametersDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.SqsParameters] inside the given [block]
         */
        public fun sqsParameters(block: aws.sdk.kotlin.services.scheduler.model.SqsParameters.Builder.() -> kotlin.Unit) {
            this.sqsParameters = awsSdkKotlinServicesSchedulerModelSqsParametersDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
