// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The templated target type for the Amazon ECS `RunTask`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation.
 */
public class EcsParameters private constructor(builder: Builder) {
    /**
     * The capacity provider strategy to use for the task.
     */
    public val capacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.capacityProviderStrategy
    /**
     * Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon ECS Developer Guide*.
     */
    public val enableEcsManagedTags: kotlin.Boolean? = builder.enableEcsManagedTags
    /**
     * Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
     */
    public val enableExecuteCommand: kotlin.Boolean? = builder.enableExecuteCommand
    /**
     * Specifies an ECS task group for the task. The maximum length is 255 characters.
     */
    public val group: kotlin.String? = builder.group
    /**
     * Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html) in the *Amazon ECS Developer Guide*.
     */
    public val launchType: aws.sdk.kotlin.services.scheduler.model.LaunchType? = builder.launchType
    /**
     * This structure specifies the network configuration for an ECS task.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.scheduler.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
     */
    public val placementConstraints: List<PlacementConstraint>? = builder.placementConstraints
    /**
     * The task placement strategy for a task or service.
     */
    public val placementStrategy: List<PlacementStrategy>? = builder.placementStrategy
    /**
     * Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use Amazon ECS's `TagResource`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html) API action.
     */
    public val propagateTags: aws.sdk.kotlin.services.scheduler.model.PropagateTags? = builder.propagateTags
    /**
     * The reference ID to use for the task.
     */
    public val referenceId: kotlin.String? = builder.referenceId
    /**
     * The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. For more information, see `RunTask`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in the *Amazon ECS API Reference*.
     */
    public val tags: List<Map<String, String>>? = builder.tags
    /**
     * The number of tasks to create based on `TaskDefinition`. The default is `1`.
     */
    public val taskCount: kotlin.Int? = builder.taskCount
    /**
     * The Amazon Resource Name (ARN) of the task definition to use if the event target is an Amazon ECS task.
     */
    public val taskDefinitionArn: kotlin.String = requireNotNull(builder.taskDefinitionArn) { "A non-null value must be provided for taskDefinitionArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.scheduler.model.EcsParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcsParameters(")
        append("capacityProviderStrategy=$capacityProviderStrategy,")
        append("enableEcsManagedTags=$enableEcsManagedTags,")
        append("enableExecuteCommand=$enableExecuteCommand,")
        append("group=$group,")
        append("launchType=$launchType,")
        append("networkConfiguration=$networkConfiguration,")
        append("placementConstraints=$placementConstraints,")
        append("placementStrategy=$placementStrategy,")
        append("platformVersion=$platformVersion,")
        append("propagateTags=$propagateTags,")
        append("referenceId=$referenceId,")
        append("tags=$tags,")
        append("taskCount=$taskCount,")
        append("taskDefinitionArn=$taskDefinitionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviderStrategy?.hashCode() ?: 0
        result = 31 * result + (enableEcsManagedTags?.hashCode() ?: 0)
        result = 31 * result + (enableExecuteCommand?.hashCode() ?: 0)
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (placementStrategy?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (referenceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskCount ?: 0)
        result = 31 * result + (taskDefinitionArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcsParameters

        if (capacityProviderStrategy != other.capacityProviderStrategy) return false
        if (enableEcsManagedTags != other.enableEcsManagedTags) return false
        if (enableExecuteCommand != other.enableExecuteCommand) return false
        if (group != other.group) return false
        if (launchType != other.launchType) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (placementConstraints != other.placementConstraints) return false
        if (placementStrategy != other.placementStrategy) return false
        if (platformVersion != other.platformVersion) return false
        if (propagateTags != other.propagateTags) return false
        if (referenceId != other.referenceId) return false
        if (tags != other.tags) return false
        if (taskCount != other.taskCount) return false
        if (taskDefinitionArn != other.taskDefinitionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.scheduler.model.EcsParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The capacity provider strategy to use for the task.
         */
        public var capacityProviderStrategy: List<CapacityProviderStrategyItem>? = null
        /**
         * Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon ECS Developer Guide*.
         */
        public var enableEcsManagedTags: kotlin.Boolean? = null
        /**
         * Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
         */
        public var enableExecuteCommand: kotlin.Boolean? = null
        /**
         * Specifies an ECS task group for the task. The maximum length is 255 characters.
         */
        public var group: kotlin.String? = null
        /**
         * Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html) in the *Amazon ECS Developer Guide*.
         */
        public var launchType: aws.sdk.kotlin.services.scheduler.model.LaunchType? = null
        /**
         * This structure specifies the network configuration for an ECS task.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.scheduler.model.NetworkConfiguration? = null
        /**
         * An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
         */
        public var placementConstraints: List<PlacementConstraint>? = null
        /**
         * The task placement strategy for a task or service.
         */
        public var placementStrategy: List<PlacementStrategy>? = null
        /**
         * Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use Amazon ECS's `TagResource`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html) API action.
         */
        public var propagateTags: aws.sdk.kotlin.services.scheduler.model.PropagateTags? = null
        /**
         * The reference ID to use for the task.
         */
        public var referenceId: kotlin.String? = null
        /**
         * The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. For more information, see `RunTask`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in the *Amazon ECS API Reference*.
         */
        public var tags: List<Map<String, String>>? = null
        /**
         * The number of tasks to create based on `TaskDefinition`. The default is `1`.
         */
        public var taskCount: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the task definition to use if the event target is an Amazon ECS task.
         */
        public var taskDefinitionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.scheduler.model.EcsParameters) : this() {
            this.capacityProviderStrategy = x.capacityProviderStrategy
            this.enableEcsManagedTags = x.enableEcsManagedTags
            this.enableExecuteCommand = x.enableExecuteCommand
            this.group = x.group
            this.launchType = x.launchType
            this.networkConfiguration = x.networkConfiguration
            this.placementConstraints = x.placementConstraints
            this.placementStrategy = x.placementStrategy
            this.platformVersion = x.platformVersion
            this.propagateTags = x.propagateTags
            this.referenceId = x.referenceId
            this.tags = x.tags
            this.taskCount = x.taskCount
            this.taskDefinitionArn = x.taskDefinitionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.scheduler.model.EcsParameters = EcsParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.scheduler.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.scheduler.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.scheduler.model.NetworkConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (taskDefinitionArn == null) taskDefinitionArn = ""
            return this
        }
    }
}
