// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler.serde

import aws.sdk.kotlin.services.scheduler.model.ActionAfterCompletion
import aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow
import aws.sdk.kotlin.services.scheduler.model.GetScheduleResponse
import aws.sdk.kotlin.services.scheduler.model.ScheduleState
import aws.sdk.kotlin.services.scheduler.model.SchedulerException
import aws.sdk.kotlin.services.scheduler.model.Target
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetScheduleOperationDeserializer: HttpDeserializer.NonStreaming<GetScheduleResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetScheduleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetScheduleError(context, call, payload)
        }
        val builder = GetScheduleResponse.Builder()

        if (payload != null) {
            deserializeGetScheduleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetScheduleError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SchedulerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SchedulerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetScheduleOperationBody(builder: GetScheduleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONAFTERCOMPLETION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActionAfterCompletion"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndDate"))
    val FLEXIBLETIMEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FlexibleTimeWindow"))
    val GROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GroupName"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyArn"))
    val LASTMODIFICATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SCHEDULEEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScheduleExpression"))
    val SCHEDULEEXPRESSIONTIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScheduleExpressionTimezone"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartDate"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Target"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONAFTERCOMPLETION_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDDATE_DESCRIPTOR)
        field(FLEXIBLETIMEWINDOW_DESCRIPTOR)
        field(GROUPNAME_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(LASTMODIFICATIONDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SCHEDULEEXPRESSION_DESCRIPTOR)
        field(SCHEDULEEXPRESSIONTIMEZONE_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONAFTERCOMPLETION_DESCRIPTOR.index -> builder.actionAfterCompletion = deserializeString().let { ActionAfterCompletion.fromValue(it) }
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDDATE_DESCRIPTOR.index -> builder.endDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FLEXIBLETIMEWINDOW_DESCRIPTOR.index -> builder.flexibleTimeWindow = deserializeFlexibleTimeWindowDocument(deserializer)
                GROUPNAME_DESCRIPTOR.index -> builder.groupName = deserializeString()
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                LASTMODIFICATIONDATE_DESCRIPTOR.index -> builder.lastModificationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SCHEDULEEXPRESSION_DESCRIPTOR.index -> builder.scheduleExpression = deserializeString()
                SCHEDULEEXPRESSIONTIMEZONE_DESCRIPTOR.index -> builder.scheduleExpressionTimezone = deserializeString()
                STARTDATE_DESCRIPTOR.index -> builder.startDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ScheduleState.fromValue(it) }
                TARGET_DESCRIPTOR.index -> builder.target = deserializeTargetDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
