// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `RetryPolicy` object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
 */
public class RetryPolicy private constructor(builder: Builder) {
    /**
     * The maximum amount of time, in seconds, to continue to make retry attempts.
     */
    public val maximumEventAgeInSeconds: kotlin.Int? = builder.maximumEventAgeInSeconds
    /**
     * The maximum number of retry attempts to make before the request fails. Retry attempts with exponential backoff continue until either the maximum number of attempts is made or until the duration of the `MaximumEventAgeInSeconds` is reached.
     */
    public val maximumRetryAttempts: kotlin.Int? = builder.maximumRetryAttempts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.scheduler.model.RetryPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetryPolicy(")
        append("maximumEventAgeInSeconds=$maximumEventAgeInSeconds,")
        append("maximumRetryAttempts=$maximumRetryAttempts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maximumEventAgeInSeconds ?: 0
        result = 31 * result + (maximumRetryAttempts ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetryPolicy

        if (maximumEventAgeInSeconds != other.maximumEventAgeInSeconds) return false
        if (maximumRetryAttempts != other.maximumRetryAttempts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.scheduler.model.RetryPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum amount of time, in seconds, to continue to make retry attempts.
         */
        public var maximumEventAgeInSeconds: kotlin.Int? = null
        /**
         * The maximum number of retry attempts to make before the request fails. Retry attempts with exponential backoff continue until either the maximum number of attempts is made or until the duration of the `MaximumEventAgeInSeconds` is reached.
         */
        public var maximumRetryAttempts: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.scheduler.model.RetryPolicy) : this() {
            this.maximumEventAgeInSeconds = x.maximumEventAgeInSeconds
            this.maximumRetryAttempts = x.maximumRetryAttempts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.scheduler.model.RetryPolicy = RetryPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
