// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler.serde

import aws.sdk.kotlin.services.scheduler.model.ActionAfterCompletion
import aws.sdk.kotlin.services.scheduler.model.CreateScheduleRequest
import aws.sdk.kotlin.services.scheduler.model.FlexibleTimeWindow
import aws.sdk.kotlin.services.scheduler.model.ScheduleState
import aws.sdk.kotlin.services.scheduler.model.Target
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateScheduleOperationSerializer: HttpSerializer.NonStreaming<CreateScheduleRequest> {
    override fun serialize(context: ExecutionContext, input: CreateScheduleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("schedules"))
                add(PercentEncoding.SmithyLabel.encode(input.name))
            }
        }

        val payload = serializeCreateScheduleOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateScheduleOperationBody(context: ExecutionContext, input: CreateScheduleRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONAFTERCOMPLETION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActionAfterCompletion"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndDate"))
    val FLEXIBLETIMEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FlexibleTimeWindow"))
    val GROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GroupName"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyArn"))
    val SCHEDULEEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScheduleExpression"))
    val SCHEDULEEXPRESSIONTIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScheduleExpressionTimezone"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartDate"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Target"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONAFTERCOMPLETION_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDDATE_DESCRIPTOR)
        field(FLEXIBLETIMEWINDOW_DESCRIPTOR)
        field(GROUPNAME_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(SCHEDULEEXPRESSION_DESCRIPTOR)
        field(SCHEDULEEXPRESSIONTIMEZONE_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.actionAfterCompletion?.let { field(ACTIONAFTERCOMPLETION_DESCRIPTOR, it.value) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.endDate?.let { field(ENDDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.flexibleTimeWindow?.let { field(FLEXIBLETIMEWINDOW_DESCRIPTOR, it, ::serializeFlexibleTimeWindowDocument) }
        input.groupName?.let { field(GROUPNAME_DESCRIPTOR, it) }
        input.kmsKeyArn?.let { field(KMSKEYARN_DESCRIPTOR, it) }
        field(SCHEDULEEXPRESSION_DESCRIPTOR, input.scheduleExpression)
        input.scheduleExpressionTimezone?.let { field(SCHEDULEEXPRESSIONTIMEZONE_DESCRIPTOR, it) }
        input.startDate?.let { field(STARTDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.state?.let { field(STATE_DESCRIPTOR, it.value) }
        input.target?.let { field(TARGET_DESCRIPTOR, it, ::serializeTargetDocument) }
    }
    return serializer.toByteArray()
}
