// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler.paginators

import aws.sdk.kotlin.services.scheduler.SchedulerClient
import aws.sdk.kotlin.services.scheduler.model.ListScheduleGroupsRequest
import aws.sdk.kotlin.services.scheduler.model.ListScheduleGroupsResponse
import aws.sdk.kotlin.services.scheduler.model.ListSchedulesRequest
import aws.sdk.kotlin.services.scheduler.model.ListSchedulesResponse
import aws.sdk.kotlin.services.scheduler.model.ScheduleGroupSummary
import aws.sdk.kotlin.services.scheduler.model.ScheduleSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListScheduleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScheduleGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScheduleGroupsResponse]
 */
public fun SchedulerClient.listScheduleGroupsPaginated(initialRequest: ListScheduleGroupsRequest = ListScheduleGroupsRequest { }): Flow<ListScheduleGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScheduleGroupsPaginated.listScheduleGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListScheduleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScheduleGroupsResponse]
 */
public fun SchedulerClient.listScheduleGroupsPaginated(block: ListScheduleGroupsRequest.Builder.() -> Unit): Flow<ListScheduleGroupsResponse> =
    listScheduleGroupsPaginated(ListScheduleGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listScheduleGroupsPaginated]
 * to access the nested member [ScheduleGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScheduleGroupSummary]
 */
@JvmName("listScheduleGroupsResponseScheduleGroupSummary")
public fun Flow<ListScheduleGroupsResponse>.scheduleGroups(): Flow<ScheduleGroupSummary> =
    transform() { response ->
        response.scheduleGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSchedulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSchedulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchedulesResponse]
 */
public fun SchedulerClient.listSchedulesPaginated(initialRequest: ListSchedulesRequest = ListSchedulesRequest { }): Flow<ListSchedulesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSchedulesPaginated.listSchedules(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSchedulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchedulesResponse]
 */
public fun SchedulerClient.listSchedulesPaginated(block: ListSchedulesRequest.Builder.() -> Unit): Flow<ListSchedulesResponse> =
    listSchedulesPaginated(ListSchedulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSchedulesPaginated]
 * to access the nested member [ScheduleSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScheduleSummary]
 */
@JvmName("listSchedulesResponseScheduleSummary")
public fun Flow<ListSchedulesResponse>.schedules(): Flow<ScheduleSummary> =
    transform() { response ->
        response.schedules?.forEach {
            emit(it)
        }
    }
