// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.scheduler

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.scheduler.auth.DefaultSchedulerAuthSchemeProvider
import aws.sdk.kotlin.services.scheduler.auth.SchedulerAuthSchemeProvider
import aws.sdk.kotlin.services.scheduler.endpoints.DefaultSchedulerEndpointProvider
import aws.sdk.kotlin.services.scheduler.endpoints.SchedulerEndpointParameters
import aws.sdk.kotlin.services.scheduler.endpoints.SchedulerEndpointProvider
import aws.sdk.kotlin.services.scheduler.model.CreateScheduleGroupRequest
import aws.sdk.kotlin.services.scheduler.model.CreateScheduleGroupResponse
import aws.sdk.kotlin.services.scheduler.model.CreateScheduleRequest
import aws.sdk.kotlin.services.scheduler.model.CreateScheduleResponse
import aws.sdk.kotlin.services.scheduler.model.DeleteScheduleGroupRequest
import aws.sdk.kotlin.services.scheduler.model.DeleteScheduleGroupResponse
import aws.sdk.kotlin.services.scheduler.model.DeleteScheduleRequest
import aws.sdk.kotlin.services.scheduler.model.DeleteScheduleResponse
import aws.sdk.kotlin.services.scheduler.model.GetScheduleGroupRequest
import aws.sdk.kotlin.services.scheduler.model.GetScheduleGroupResponse
import aws.sdk.kotlin.services.scheduler.model.GetScheduleRequest
import aws.sdk.kotlin.services.scheduler.model.GetScheduleResponse
import aws.sdk.kotlin.services.scheduler.model.ListScheduleGroupsRequest
import aws.sdk.kotlin.services.scheduler.model.ListScheduleGroupsResponse
import aws.sdk.kotlin.services.scheduler.model.ListSchedulesRequest
import aws.sdk.kotlin.services.scheduler.model.ListSchedulesResponse
import aws.sdk.kotlin.services.scheduler.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.scheduler.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.scheduler.model.TagResourceRequest
import aws.sdk.kotlin.services.scheduler.model.TagResourceResponse
import aws.sdk.kotlin.services.scheduler.model.UntagResourceRequest
import aws.sdk.kotlin.services.scheduler.model.UntagResourceResponse
import aws.sdk.kotlin.services.scheduler.model.UpdateScheduleRequest
import aws.sdk.kotlin.services.scheduler.model.UpdateScheduleResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Scheduler"
public const val SdkVersion: String = "1.5.19"
public const val ServiceApiVersion: String = "2021-06-30"

/**
 * Amazon EventBridge Scheduler is a serverless scheduler that allows you to create, run, and manage tasks from one central, managed service. EventBridge Scheduler delivers your tasks reliably, with built-in mechanisms that adjust your schedules based on the availability of downstream targets. The following reference lists the available API actions, and data types for EventBridge Scheduler.
 */
public interface SchedulerClient : SdkClient {
    /**
     * SchedulerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SchedulerClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Scheduler",
                "SCHEDULER",
                "scheduler",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SchedulerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SchedulerClient = DefaultSchedulerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SchedulerEndpointProvider = builder.endpointProvider ?: DefaultSchedulerEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SchedulerAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSchedulerAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Scheduler"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SchedulerEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SchedulerAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates the specified schedule.
     */
    public suspend fun createSchedule(input: CreateScheduleRequest): CreateScheduleResponse

    /**
     * Creates the specified schedule group.
     */
    public suspend fun createScheduleGroup(input: CreateScheduleGroupRequest): CreateScheduleGroupResponse

    /**
     * Deletes the specified schedule.
     */
    public suspend fun deleteSchedule(input: DeleteScheduleRequest): DeleteScheduleResponse

    /**
     * Deletes the specified schedule group. Deleting a schedule group results in EventBridge Scheduler deleting all schedules associated with the group. When you delete a group, it remains in a `DELETING` state until all of its associated schedules are deleted. Schedules associated with the group that are set to run while the schedule group is in the process of being deleted might continue to invoke their targets until the schedule group and its associated schedules are deleted.
     *
     *  This operation is eventually consistent.
     */
    public suspend fun deleteScheduleGroup(input: DeleteScheduleGroupRequest): DeleteScheduleGroupResponse

    /**
     * Retrieves the specified schedule.
     */
    public suspend fun getSchedule(input: GetScheduleRequest): GetScheduleResponse

    /**
     * Retrieves the specified schedule group.
     */
    public suspend fun getScheduleGroup(input: GetScheduleGroupRequest): GetScheduleGroupResponse

    /**
     * Returns a paginated list of your schedule groups.
     */
    public suspend fun listScheduleGroups(input: ListScheduleGroupsRequest = ListScheduleGroupsRequest { }): ListScheduleGroupsResponse

    /**
     * Returns a paginated list of your EventBridge Scheduler schedules.
     */
    public suspend fun listSchedules(input: ListSchedulesRequest = ListSchedulesRequest { }): ListSchedulesResponse

    /**
     * Lists the tags associated with the Scheduler resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified EventBridge Scheduler resource. You can only assign tags to schedule groups.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified EventBridge Scheduler schedule group.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified schedule. When you call `UpdateSchedule`, EventBridge Scheduler uses all values, including empty values, specified in the request and overrides the existing schedule. This is by design. This means that if you do not set an optional field in your request, that field will be set to its system-default value after the update.
     *
     *  Before calling this operation, we recommend that you call the `GetSchedule` API operation and make a note of all optional parameters for your `UpdateSchedule` call.
     */
    public suspend fun updateSchedule(input: UpdateScheduleRequest): UpdateScheduleResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SchedulerClient.withConfig(block: SchedulerClient.Config.Builder.() -> Unit): SchedulerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSchedulerClient(newConfig)
}

/**
 * Creates the specified schedule.
 */
public suspend inline fun SchedulerClient.createSchedule(crossinline block: CreateScheduleRequest.Builder.() -> Unit): CreateScheduleResponse = createSchedule(CreateScheduleRequest.Builder().apply(block).build())

/**
 * Creates the specified schedule group.
 */
public suspend inline fun SchedulerClient.createScheduleGroup(crossinline block: CreateScheduleGroupRequest.Builder.() -> Unit): CreateScheduleGroupResponse = createScheduleGroup(CreateScheduleGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified schedule.
 */
public suspend inline fun SchedulerClient.deleteSchedule(crossinline block: DeleteScheduleRequest.Builder.() -> Unit): DeleteScheduleResponse = deleteSchedule(DeleteScheduleRequest.Builder().apply(block).build())

/**
 * Deletes the specified schedule group. Deleting a schedule group results in EventBridge Scheduler deleting all schedules associated with the group. When you delete a group, it remains in a `DELETING` state until all of its associated schedules are deleted. Schedules associated with the group that are set to run while the schedule group is in the process of being deleted might continue to invoke their targets until the schedule group and its associated schedules are deleted.
 *
 *  This operation is eventually consistent.
 */
public suspend inline fun SchedulerClient.deleteScheduleGroup(crossinline block: DeleteScheduleGroupRequest.Builder.() -> Unit): DeleteScheduleGroupResponse = deleteScheduleGroup(DeleteScheduleGroupRequest.Builder().apply(block).build())

/**
 * Retrieves the specified schedule.
 */
public suspend inline fun SchedulerClient.getSchedule(crossinline block: GetScheduleRequest.Builder.() -> Unit): GetScheduleResponse = getSchedule(GetScheduleRequest.Builder().apply(block).build())

/**
 * Retrieves the specified schedule group.
 */
public suspend inline fun SchedulerClient.getScheduleGroup(crossinline block: GetScheduleGroupRequest.Builder.() -> Unit): GetScheduleGroupResponse = getScheduleGroup(GetScheduleGroupRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of your schedule groups.
 */
public suspend inline fun SchedulerClient.listScheduleGroups(crossinline block: ListScheduleGroupsRequest.Builder.() -> Unit): ListScheduleGroupsResponse = listScheduleGroups(ListScheduleGroupsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of your EventBridge Scheduler schedules.
 */
public suspend inline fun SchedulerClient.listSchedules(crossinline block: ListSchedulesRequest.Builder.() -> Unit): ListSchedulesResponse = listSchedules(ListSchedulesRequest.Builder().apply(block).build())

/**
 * Lists the tags associated with the Scheduler resource.
 */
public suspend inline fun SchedulerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified EventBridge Scheduler resource. You can only assign tags to schedule groups.
 */
public suspend inline fun SchedulerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified EventBridge Scheduler schedule group.
 */
public suspend inline fun SchedulerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified schedule. When you call `UpdateSchedule`, EventBridge Scheduler uses all values, including empty values, specified in the request and overrides the existing schedule. This is by design. This means that if you do not set an optional field in your request, that field will be set to its system-default value after the update.
 *
 *  Before calling this operation, we recommend that you call the `GetSchedule` API operation and make a note of all optional parameters for your `UpdateSchedule` call.
 */
public suspend inline fun SchedulerClient.updateSchedule(crossinline block: UpdateScheduleRequest.Builder.() -> Unit): UpdateScheduleResponse = updateSchedule(UpdateScheduleRequest.Builder().apply(block).build())
