// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.serde

import aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointResponse
import aws.sdk.kotlin.services.sagemakerruntime.model.SageMakerRuntimeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class InvokeEndpointOperationDeserializer: HttpDeserializer.NonStreaming<InvokeEndpointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): InvokeEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwInvokeEndpointError(context, call, payload)
        }
        val builder = InvokeEndpointResponse.Builder()

        builder.closedSessionId = response.headers["X-Amzn-SageMaker-Closed-Session-Id"]
        builder.contentType = response.headers["Content-Type"]
        builder.customAttributes = response.headers["X-Amzn-SageMaker-Custom-Attributes"]
        builder.invokedProductionVariant = response.headers["x-Amzn-Invoked-Production-Variant"]
        builder.newSessionId = response.headers["X-Amzn-SageMaker-New-Session-Id"]

        builder.body = payload

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwInvokeEndpointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalDependencyException" -> InternalDependencyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ModelNotReadyException" -> ModelNotReadyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ModelError" -> ModelErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
