// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.serde

import aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class InvokeEndpointOperationSerializer: HttpSerializer.NonStreaming<InvokeEndpointRequest> {
    override fun serialize(context: ExecutionContext, input: InvokeEndpointRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.endpointName) { "endpointName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("endpoints"))
                add(PercentEncoding.SmithyLabel.encode(input.endpointName))
                add(PercentEncoding.Path.encode("invocations"))
            }
        }

        builder.headers {
            if (input.accept?.isNotEmpty() == true) append("Accept", input.accept)
            if (input.contentType?.isNotEmpty() == true) append("Content-Type", input.contentType)
            if (input.customAttributes?.isNotEmpty() == true) append("X-Amzn-SageMaker-Custom-Attributes", input.customAttributes)
            if (input.enableExplanations?.isNotEmpty() == true) append("X-Amzn-SageMaker-Enable-Explanations", input.enableExplanations)
            if (input.inferenceComponentName?.isNotEmpty() == true) append("X-Amzn-SageMaker-Inference-Component", input.inferenceComponentName)
            if (input.inferenceId?.isNotEmpty() == true) append("X-Amzn-SageMaker-Inference-Id", input.inferenceId)
            if (input.sessionId?.isNotEmpty() == true) append("X-Amzn-SageMaker-Session-Id", input.sessionId)
            if (input.targetContainerHostname?.isNotEmpty() == true) append("X-Amzn-SageMaker-Target-Container-Hostname", input.targetContainerHostname)
            if (input.targetModel?.isNotEmpty() == true) append("X-Amzn-SageMaker-Target-Model", input.targetModel)
            if (input.targetVariant?.isNotEmpty() == true) append("X-Amzn-SageMaker-Target-Variant", input.targetVariant)
        }

        if (input.body != null) {
            builder.body = HttpBody.fromBytes(input.body)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.body == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
