// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.serde

import aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointWithResponseStreamResponse
import aws.sdk.kotlin.services.sagemakerruntime.model.PayloadPart
import aws.sdk.kotlin.services.sagemakerruntime.model.ResponseStream
import aws.sdk.kotlin.services.sagemakerruntime.model.SageMakerRuntimeException
import aws.smithy.kotlin.runtime.ClientException
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.MessageType
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.decodeFrames
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.type
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class InvokeEndpointWithResponseStreamOperationDeserializer: HttpDeserializer.Streaming<InvokeEndpointWithResponseStreamResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): InvokeEndpointWithResponseStreamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            val payload = response.body.readAll()
            throwInvokeEndpointWithResponseStreamError(context, call, payload)
        }
        val builder = InvokeEndpointWithResponseStreamResponse.Builder()

        builder.contentType = response.headers["X-Amzn-SageMaker-Content-Type"]
        builder.customAttributes = response.headers["X-Amzn-SageMaker-Custom-Attributes"]
        builder.invokedProductionVariant = response.headers["x-Amzn-Invoked-Production-Variant"]

        deserializeInvokeEndpointWithResponseStreamOperationBody(builder, call)
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwInvokeEndpointWithResponseStreamError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ModelError" -> ModelErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ModelStreamError" -> ModelStreamErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InternalStreamFailure" -> InternalStreamFailureDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeInvokeEndpointWithResponseStreamOperationBody(builder: InvokeEndpointWithResponseStreamResponse.Builder, call: HttpCall) {
    val chan = call.response.body.toSdkByteReadChannel(call) ?: return
    val frames = decodeFrames(chan)
    val events = frames
        .map { message ->
            when (val mt = message.type()) {
                is MessageType.Event -> when (mt.shapeType) {
                    "PayloadPart" -> {
                        val eb = PayloadPart.Builder()
                        eb.bytes = message.payload
                        val e = eb.build()
                        ResponseStream.PayloadPart(e)
                    }
                    else -> ResponseStream.SdkUnknown
                }
                is MessageType.Exception -> when (mt.shapeType) {
                    "ModelStreamError" -> {
                        val err = deserializeModelStreamErrorPayload(message.payload)
                        throw err
                    }
                    "InternalStreamFailure" -> {
                        val err = deserializeInternalStreamFailurePayload(message.payload)
                        throw err
                    }
                    else -> throw SageMakerRuntimeException("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw SageMakerRuntimeException("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }

    builder.body = events
}
