// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.model

import aws.smithy.kotlin.runtime.SdkDsl

public class InvokeEndpointRequest private constructor(builder: Builder) {
    /**
     * The desired MIME type of the inference response from the model container.
     */
    public val accept: kotlin.String? = builder.accept
    /**
     * Provides input data, in the format specified in the `ContentType` request header. Amazon SageMaker passes all of the data in the body to the model.
     *
     * For information about the format of the request body, see [Common Data Formats-Inference](https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html).
     */
    public val body: kotlin.ByteArray? = builder.body
    /**
     * The MIME type of the input data in the request body.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in [Section 3.3.6. Field Value Components](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6) of the Hypertext Transfer Protocol (HTTP/1.1).
     *
     * The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with `Trace ID:` in your post-processing function.
     *
     * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.
     */
    public val customAttributes: kotlin.String? = builder.customAttributes
    /**
     * An optional JMESPath expression used to override the `EnableExplanations` parameter of the `ClarifyExplainerConfig` API. See the [EnableExplanations](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable) section in the developer guide for more information.
     */
    public val enableExplanations: kotlin.String? = builder.enableExplanations
    /**
     * The name of the endpoint that you specified when you created the endpoint using the [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html) API.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * If the endpoint hosts one or more inference components, this parameter specifies the name of inference component to invoke.
     */
    public val inferenceComponentName: kotlin.String? = builder.inferenceComponentName
    /**
     * If you provide a value, it is added to the captured data when you enable data capture on the endpoint. For information about data capture, see [Capture Data](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html).
     */
    public val inferenceId: kotlin.String? = builder.inferenceId
    /**
     * If the endpoint hosts multiple containers and is configured to use direct invocation, this parameter specifies the host name of the container to invoke.
     */
    public val targetContainerHostname: kotlin.String? = builder.targetContainerHostname
    /**
     * The model to request for inference when invoking a multi-model endpoint.
     */
    public val targetModel: kotlin.String? = builder.targetModel
    /**
     * Specify the production variant to send the inference request to when invoking an endpoint that is running two or more variants. Note that this parameter overrides the default behavior for the endpoint, which is to distribute the invocation traffic based on the variant weights.
     *
     * For information about how to use variant targeting to perform a/b testing, see [Test models in production](https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html)
     */
    public val targetVariant: kotlin.String? = builder.targetVariant

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvokeEndpointRequest(")
        append("accept=$accept,")
        append("body=*** Sensitive Data Redacted ***,")
        append("contentType=$contentType,")
        append("customAttributes=*** Sensitive Data Redacted ***,")
        append("enableExplanations=$enableExplanations,")
        append("endpointName=$endpointName,")
        append("inferenceComponentName=$inferenceComponentName,")
        append("inferenceId=$inferenceId,")
        append("targetContainerHostname=$targetContainerHostname,")
        append("targetModel=$targetModel,")
        append("targetVariant=$targetVariant")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accept?.hashCode() ?: 0
        result = 31 * result + (body?.contentHashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (customAttributes?.hashCode() ?: 0)
        result = 31 * result + (enableExplanations?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (inferenceComponentName?.hashCode() ?: 0)
        result = 31 * result + (inferenceId?.hashCode() ?: 0)
        result = 31 * result + (targetContainerHostname?.hashCode() ?: 0)
        result = 31 * result + (targetModel?.hashCode() ?: 0)
        result = 31 * result + (targetVariant?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvokeEndpointRequest

        if (accept != other.accept) return false
        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (contentType != other.contentType) return false
        if (customAttributes != other.customAttributes) return false
        if (enableExplanations != other.enableExplanations) return false
        if (endpointName != other.endpointName) return false
        if (inferenceComponentName != other.inferenceComponentName) return false
        if (inferenceId != other.inferenceId) return false
        if (targetContainerHostname != other.targetContainerHostname) return false
        if (targetModel != other.targetModel) return false
        if (targetVariant != other.targetVariant) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The desired MIME type of the inference response from the model container.
         */
        public var accept: kotlin.String? = null
        /**
         * Provides input data, in the format specified in the `ContentType` request header. Amazon SageMaker passes all of the data in the body to the model.
         *
         * For information about the format of the request body, see [Common Data Formats-Inference](https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html).
         */
        public var body: kotlin.ByteArray? = null
        /**
         * The MIME type of the input data in the request body.
         */
        public var contentType: kotlin.String? = null
        /**
         * Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in [Section 3.3.6. Field Value Components](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6) of the Hypertext Transfer Protocol (HTTP/1.1).
         *
         * The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with `Trace ID:` in your post-processing function.
         *
         * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.
         */
        public var customAttributes: kotlin.String? = null
        /**
         * An optional JMESPath expression used to override the `EnableExplanations` parameter of the `ClarifyExplainerConfig` API. See the [EnableExplanations](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable) section in the developer guide for more information.
         */
        public var enableExplanations: kotlin.String? = null
        /**
         * The name of the endpoint that you specified when you created the endpoint using the [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html) API.
         */
        public var endpointName: kotlin.String? = null
        /**
         * If the endpoint hosts one or more inference components, this parameter specifies the name of inference component to invoke.
         */
        public var inferenceComponentName: kotlin.String? = null
        /**
         * If you provide a value, it is added to the captured data when you enable data capture on the endpoint. For information about data capture, see [Capture Data](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html).
         */
        public var inferenceId: kotlin.String? = null
        /**
         * If the endpoint hosts multiple containers and is configured to use direct invocation, this parameter specifies the host name of the container to invoke.
         */
        public var targetContainerHostname: kotlin.String? = null
        /**
         * The model to request for inference when invoking a multi-model endpoint.
         */
        public var targetModel: kotlin.String? = null
        /**
         * Specify the production variant to send the inference request to when invoking an endpoint that is running two or more variants. Note that this parameter overrides the default behavior for the endpoint, which is to distribute the invocation traffic based on the variant weights.
         *
         * For information about how to use variant targeting to perform a/b testing, see [Test models in production](https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html)
         */
        public var targetVariant: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointRequest) : this() {
            this.accept = x.accept
            this.body = x.body
            this.contentType = x.contentType
            this.customAttributes = x.customAttributes
            this.enableExplanations = x.enableExplanations
            this.endpointName = x.endpointName
            this.inferenceComponentName = x.inferenceComponentName
            this.inferenceId = x.inferenceId
            this.targetContainerHostname = x.targetContainerHostname
            this.targetModel = x.targetModel
            this.targetVariant = x.targetVariant
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointRequest = InvokeEndpointRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
