// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.model

import aws.smithy.kotlin.runtime.SdkDsl

public class InvokeEndpointAsyncRequest private constructor(builder: Builder) {
    /**
     * The desired MIME type of the inference response from the model container.
     */
    public val accept: kotlin.String? = builder.accept
    /**
     * The MIME type of the input data in the request body.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in [Section 3.3.6. Field Value Components](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6) of the Hypertext Transfer Protocol (HTTP/1.1).
     *
     * The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with `Trace ID:` in your post-processing function.
     *
     * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.
     */
    public val customAttributes: kotlin.String? = builder.customAttributes
    /**
     * The name of the endpoint that you specified when you created the endpoint using the [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html) API.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none is specified.
     */
    public val inferenceId: kotlin.String? = builder.inferenceId
    /**
     * The Amazon S3 URI where the inference request payload is stored.
     */
    public val inputLocation: kotlin.String? = builder.inputLocation
    /**
     * Maximum amount of time in seconds a request can be processed before it is marked as expired. The default is 15 minutes, or 900 seconds.
     */
    public val invocationTimeoutSeconds: kotlin.Int? = builder.invocationTimeoutSeconds
    /**
     * Maximum age in seconds a request can be in the queue before it is marked as expired. The default is 6 hours, or 21,600 seconds.
     */
    public val requestTtlSeconds: kotlin.Int? = builder.requestTtlSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvokeEndpointAsyncRequest(")
        append("accept=$accept,")
        append("contentType=$contentType,")
        append("customAttributes=*** Sensitive Data Redacted ***,")
        append("endpointName=$endpointName,")
        append("inferenceId=$inferenceId,")
        append("inputLocation=$inputLocation,")
        append("invocationTimeoutSeconds=$invocationTimeoutSeconds,")
        append("requestTtlSeconds=$requestTtlSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accept?.hashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (customAttributes?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (inferenceId?.hashCode() ?: 0)
        result = 31 * result + (inputLocation?.hashCode() ?: 0)
        result = 31 * result + (invocationTimeoutSeconds ?: 0)
        result = 31 * result + (requestTtlSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvokeEndpointAsyncRequest

        if (accept != other.accept) return false
        if (contentType != other.contentType) return false
        if (customAttributes != other.customAttributes) return false
        if (endpointName != other.endpointName) return false
        if (inferenceId != other.inferenceId) return false
        if (inputLocation != other.inputLocation) return false
        if (invocationTimeoutSeconds != other.invocationTimeoutSeconds) return false
        if (requestTtlSeconds != other.requestTtlSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The desired MIME type of the inference response from the model container.
         */
        public var accept: kotlin.String? = null
        /**
         * The MIME type of the input data in the request body.
         */
        public var contentType: kotlin.String? = null
        /**
         * Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in [Section 3.3.6. Field Value Components](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6) of the Hypertext Transfer Protocol (HTTP/1.1).
         *
         * The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with `Trace ID:` in your post-processing function.
         *
         * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.
         */
        public var customAttributes: kotlin.String? = null
        /**
         * The name of the endpoint that you specified when you created the endpoint using the [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html) API.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none is specified.
         */
        public var inferenceId: kotlin.String? = null
        /**
         * The Amazon S3 URI where the inference request payload is stored.
         */
        public var inputLocation: kotlin.String? = null
        /**
         * Maximum amount of time in seconds a request can be processed before it is marked as expired. The default is 15 minutes, or 900 seconds.
         */
        public var invocationTimeoutSeconds: kotlin.Int? = null
        /**
         * Maximum age in seconds a request can be in the queue before it is marked as expired. The default is 6 hours, or 21,600 seconds.
         */
        public var requestTtlSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncRequest) : this() {
            this.accept = x.accept
            this.contentType = x.contentType
            this.customAttributes = x.customAttributes
            this.endpointName = x.endpointName
            this.inferenceId = x.inferenceId
            this.inputLocation = x.inputLocation
            this.invocationTimeoutSeconds = x.invocationTimeoutSeconds
            this.requestTtlSeconds = x.requestTtlSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncRequest = InvokeEndpointAsyncRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
