// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.serde

import aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointWithResponseStreamRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class InvokeEndpointWithResponseStreamOperationSerializer: HttpSerialize<InvokeEndpointWithResponseStreamRequest> {
    override suspend fun serialize(context: ExecutionContext, input: InvokeEndpointWithResponseStreamRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.endpointName) { "endpointName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("endpoints"))
                add(PercentEncoding.SmithyLabel.encode("${input.endpointName}"))
                add(PercentEncoding.Path.encode("invocations-response-stream"))
            }
        }

        builder.headers {
            if (input.accept?.isNotEmpty() == true) append("X-Amzn-SageMaker-Accept", input.accept)
            if (input.contentType?.isNotEmpty() == true) append("Content-Type", input.contentType)
            if (input.customAttributes?.isNotEmpty() == true) append("X-Amzn-SageMaker-Custom-Attributes", input.customAttributes)
            if (input.inferenceId?.isNotEmpty() == true) append("X-Amzn-SageMaker-Inference-Id", input.inferenceId)
            if (input.targetContainerHostname?.isNotEmpty() == true) append("X-Amzn-SageMaker-Target-Container-Hostname", input.targetContainerHostname)
            if (input.targetVariant?.isNotEmpty() == true) append("X-Amzn-SageMaker-Target-Variant", input.targetVariant)
        }

        if (input.body != null) {
            builder.body = HttpBody.fromBytes(input.body)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.body == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
