// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.serde

import aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointResponse
import aws.sdk.kotlin.services.sagemakerruntime.model.SageMakerRuntimeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class InvokeEndpointOperationDeserializer: HttpDeserialize<InvokeEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): InvokeEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwInvokeEndpointError(context, call)
        }
        val builder = InvokeEndpointResponse.Builder()

        builder.contentType = response.headers["Content-Type"]
        builder.customAttributes = response.headers["X-Amzn-SageMaker-Custom-Attributes"]
        builder.invokedProductionVariant = response.headers["x-Amzn-Invoked-Production-Variant"]

        builder.body = response.body.readAll()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwInvokeEndpointError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalDependencyException" -> InternalDependencyExceptionDeserializer().deserialize(context, wrappedCall)
        "ModelNotReadyException" -> ModelNotReadyExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedCall)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedCall)
        "ModelError" -> ModelErrorDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
