// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.serde

import aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
import aws.sdk.kotlin.services.sagemakerruntime.model.SageMakerRuntimeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class InvokeEndpointAsyncOperationDeserializer: HttpDeserialize<InvokeEndpointAsyncResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): InvokeEndpointAsyncResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwInvokeEndpointAsyncError(context, call)
        }
        val builder = InvokeEndpointAsyncResponse.Builder()

        builder.failureLocation = response.headers["X-Amzn-SageMaker-FailureLocation"]
        builder.outputLocation = response.headers["X-Amzn-SageMaker-OutputLocation"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeInvokeEndpointAsyncOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwInvokeEndpointAsyncError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedCall)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeInvokeEndpointAsyncOperationBody(builder: InvokeEndpointAsyncResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INFERENCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InferenceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INFERENCEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INFERENCEID_DESCRIPTOR.index -> builder.inferenceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
