// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemakergeospatial.model.DataCollectionType
import aws.sdk.kotlin.services.sagemakergeospatial.model.Filter
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetRasterDataCollectionResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.SageMakerGeospatialException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetRasterDataCollectionOperationDeserializer: HttpDeserialize<GetRasterDataCollectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRasterDataCollectionResponse {
        if (!response.status.isSuccess()) {
            throwGetRasterDataCollectionError(context, response)
        }
        val builder = GetRasterDataCollectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRasterDataCollectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRasterDataCollectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerGeospatialException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerGeospatialException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRasterDataCollectionOperationBody(builder: GetRasterDataCollectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DESCRIPTIONPAGEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DescriptionPageUrl"))
    val IMAGESOURCEBANDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ImageSourceBands"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SUPPORTEDFILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SupportedFilters"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DESCRIPTIONPAGEURL_DESCRIPTOR)
        field(IMAGESOURCEBANDS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SUPPORTEDFILTERS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DESCRIPTIONPAGEURL_DESCRIPTOR.index -> builder.descriptionPageUrl = deserializeString()
                IMAGESOURCEBANDS_DESCRIPTOR.index -> builder.imageSourceBands =
                    deserializer.deserializeList(IMAGESOURCEBANDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SUPPORTEDFILTERS_DESCRIPTOR.index -> builder.supportedFilters =
                    deserializer.deserializeList(SUPPORTEDFILTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Filter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { DataCollectionType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
