// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.sagemakergeospatial.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.sagemakergeospatial.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.sagemakergeospatial.model.*
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetRasterDataCollectionRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetTileRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.TagResourceRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.UntagResourceRequest
import aws.sdk.kotlin.services.sagemakergeospatial.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.execute
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "SageMaker Geospatial"
public const val ServiceApiVersion: String = "2020-05-27"
public const val SdkVersion: String = "0.20.0-beta"

internal class DefaultSageMakerGeospatialClient(override val config: SageMakerGeospatialClient.Config) : SageMakerGeospatialClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Use this operation to delete an Earth Observation job.
     */
    override suspend fun deleteEarthObservationJob(input: DeleteEarthObservationJobRequest): DeleteEarthObservationJobResponse {
        val op = SdkHttpOperation.build<DeleteEarthObservationJobRequest, DeleteEarthObservationJobResponse> {
            serializer = DeleteEarthObservationJobOperationSerializer()
            deserializer = DeleteEarthObservationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEarthObservationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteEarthObservationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEarthObservationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Use this operation to delete a Vector Enrichment job.
     */
    override suspend fun deleteVectorEnrichmentJob(input: DeleteVectorEnrichmentJobRequest): DeleteVectorEnrichmentJobResponse {
        val op = SdkHttpOperation.build<DeleteVectorEnrichmentJobRequest, DeleteVectorEnrichmentJobResponse> {
            serializer = DeleteVectorEnrichmentJobOperationSerializer()
            deserializer = DeleteVectorEnrichmentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVectorEnrichmentJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteVectorEnrichmentJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteVectorEnrichmentJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Use this operation to export results of an Earth Observation job and optionally source images used as input to the EOJ to an S3 location.
     */
    override suspend fun exportEarthObservationJob(input: ExportEarthObservationJobRequest): ExportEarthObservationJobResponse {
        val op = SdkHttpOperation.build<ExportEarthObservationJobRequest, ExportEarthObservationJobResponse> {
            serializer = ExportEarthObservationJobOperationSerializer()
            deserializer = ExportEarthObservationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportEarthObservationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ExportEarthObservationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ExportEarthObservationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Use this operation to copy results of a Vector Enrichment job to an S3 location.
     */
    override suspend fun exportVectorEnrichmentJob(input: ExportVectorEnrichmentJobRequest): ExportVectorEnrichmentJobResponse {
        val op = SdkHttpOperation.build<ExportVectorEnrichmentJobRequest, ExportVectorEnrichmentJobResponse> {
            serializer = ExportVectorEnrichmentJobOperationSerializer()
            deserializer = ExportVectorEnrichmentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportVectorEnrichmentJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ExportVectorEnrichmentJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ExportVectorEnrichmentJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get the details for a previously initiated Earth Observation job.
     */
    override suspend fun getEarthObservationJob(input: GetEarthObservationJobRequest): GetEarthObservationJobResponse {
        val op = SdkHttpOperation.build<GetEarthObservationJobRequest, GetEarthObservationJobResponse> {
            serializer = GetEarthObservationJobOperationSerializer()
            deserializer = GetEarthObservationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEarthObservationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetEarthObservationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEarthObservationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Use this operation to get details of a specific raster data collection.
     */
    override suspend fun getRasterDataCollection(input: GetRasterDataCollectionRequest): GetRasterDataCollectionResponse {
        val op = SdkHttpOperation.build<GetRasterDataCollectionRequest, GetRasterDataCollectionResponse> {
            serializer = GetRasterDataCollectionOperationSerializer()
            deserializer = GetRasterDataCollectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRasterDataCollection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetRasterDataCollectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetRasterDataCollection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a web mercator tile for the given Earth Observation job.
     */
    override suspend fun <T> getTile(input: GetTileRequest, block: suspend (GetTileResponse) -> T): T {
        val op = SdkHttpOperation.build<GetTileRequest, GetTileResponse> {
            serializer = GetTileOperationSerializer()
            deserializer = GetTileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTile"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTileRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.execute(client, input, block)
        }
    }

    /**
     * Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN).
     */
    override suspend fun getVectorEnrichmentJob(input: GetVectorEnrichmentJobRequest): GetVectorEnrichmentJobResponse {
        val op = SdkHttpOperation.build<GetVectorEnrichmentJobRequest, GetVectorEnrichmentJobResponse> {
            serializer = GetVectorEnrichmentJobOperationSerializer()
            deserializer = GetVectorEnrichmentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVectorEnrichmentJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetVectorEnrichmentJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetVectorEnrichmentJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services account.
     */
    override suspend fun listEarthObservationJobs(input: ListEarthObservationJobsRequest): ListEarthObservationJobsResponse {
        val op = SdkHttpOperation.build<ListEarthObservationJobsRequest, ListEarthObservationJobsResponse> {
            serializer = ListEarthObservationJobsOperationSerializer()
            deserializer = ListEarthObservationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEarthObservationJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListEarthObservationJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEarthObservationJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Use this operation to get raster data collections.
     */
    override suspend fun listRasterDataCollections(input: ListRasterDataCollectionsRequest): ListRasterDataCollectionsResponse {
        val op = SdkHttpOperation.build<ListRasterDataCollectionsRequest, ListRasterDataCollectionsResponse> {
            serializer = ListRasterDataCollectionsOperationSerializer()
            deserializer = ListRasterDataCollectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRasterDataCollections"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListRasterDataCollectionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListRasterDataCollections-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the tags attached to the resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of vector enrichment jobs.
     */
    override suspend fun listVectorEnrichmentJobs(input: ListVectorEnrichmentJobsRequest): ListVectorEnrichmentJobsResponse {
        val op = SdkHttpOperation.build<ListVectorEnrichmentJobsRequest, ListVectorEnrichmentJobsResponse> {
            serializer = ListVectorEnrichmentJobsOperationSerializer()
            deserializer = ListVectorEnrichmentJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVectorEnrichmentJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListVectorEnrichmentJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListVectorEnrichmentJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching the selected filters.
     */
    override suspend fun searchRasterDataCollection(input: SearchRasterDataCollectionRequest): SearchRasterDataCollectionResponse {
        val op = SdkHttpOperation.build<SearchRasterDataCollectionRequest, SearchRasterDataCollectionResponse> {
            serializer = SearchRasterDataCollectionOperationSerializer()
            deserializer = SearchRasterDataCollectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchRasterDataCollection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<SearchRasterDataCollectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SearchRasterDataCollection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Use this operation to create an Earth observation job.
     */
    override suspend fun startEarthObservationJob(input: StartEarthObservationJobRequest): StartEarthObservationJobResponse {
        val op = SdkHttpOperation.build<StartEarthObservationJobRequest, StartEarthObservationJobResponse> {
            serializer = StartEarthObservationJobOperationSerializer()
            deserializer = StartEarthObservationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartEarthObservationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartEarthObservationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartEarthObservationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a Vector Enrichment job for the supplied job type. Currently, there are two supported job types: reverse geocoding and map matching.
     */
    override suspend fun startVectorEnrichmentJob(input: StartVectorEnrichmentJobRequest): StartVectorEnrichmentJobResponse {
        val op = SdkHttpOperation.build<StartVectorEnrichmentJobRequest, StartVectorEnrichmentJobResponse> {
            serializer = StartVectorEnrichmentJobOperationSerializer()
            deserializer = StartVectorEnrichmentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartVectorEnrichmentJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartVectorEnrichmentJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartVectorEnrichmentJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Use this operation to stop an existing earth observation job.
     */
    override suspend fun stopEarthObservationJob(input: StopEarthObservationJobRequest): StopEarthObservationJobResponse {
        val op = SdkHttpOperation.build<StopEarthObservationJobRequest, StopEarthObservationJobResponse> {
            serializer = StopEarthObservationJobOperationSerializer()
            deserializer = StopEarthObservationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopEarthObservationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StopEarthObservationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopEarthObservationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops the Vector Enrichment job for a given job ARN.
     */
    override suspend fun stopVectorEnrichmentJob(input: StopVectorEnrichmentJobRequest): StopVectorEnrichmentJobResponse {
        val op = SdkHttpOperation.build<StopVectorEnrichmentJobRequest, StopVectorEnrichmentJobResponse> {
            serializer = StopVectorEnrichmentJobOperationSerializer()
            deserializer = StopVectorEnrichmentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopVectorEnrichmentJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StopVectorEnrichmentJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopVectorEnrichmentJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * The resource you want to tag.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * The resource you want to untag.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "sagemaker-geospatial"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "sagemaker-geospatial")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
