// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object containing information about the output file.
 */
public class ListEarthObservationJobOutputConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the list of the Earth Observation jobs.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The creation time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The duration of the session, in seconds.
     */
    public val durationInSeconds: kotlin.Int = requireNotNull(builder.durationInSeconds) { "A non-null value must be provided for durationInSeconds" }
    /**
     * The names of the Earth Observation jobs in the list.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The operation type for an Earth Observation job.
     */
    public val operationType: kotlin.String = requireNotNull(builder.operationType) { "A non-null value must be provided for operationType" }
    /**
     * The status of the list of the Earth Observation jobs.
     */
    public val status: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Each tag consists of a key and a value.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEarthObservationJobOutputConfig(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("durationInSeconds=$durationInSeconds,")
        append("name=$name,")
        append("operationType=$operationType,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (durationInSeconds)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (operationType.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEarthObservationJobOutputConfig

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (durationInSeconds != other.durationInSeconds) return false
        if (name != other.name) return false
        if (operationType != other.operationType) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the list of the Earth Observation jobs.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The duration of the session, in seconds.
         */
        public var durationInSeconds: kotlin.Int? = null
        /**
         * The names of the Earth Observation jobs in the list.
         */
        public var name: kotlin.String? = null
        /**
         * The operation type for an Earth Observation job.
         */
        public var operationType: kotlin.String? = null
        /**
         * The status of the list of the Earth Observation jobs.
         */
        public var status: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobStatus? = null
        /**
         * Each tag consists of a key and a value.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.durationInSeconds = x.durationInSeconds
            this.name = x.name
            this.operationType = x.operationType
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig = ListEarthObservationJobOutputConfig(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (durationInSeconds == null) durationInSeconds = 0
            if (name == null) name = ""
            if (operationType == null) operationType = ""
            if (status == null) status = EarthObservationJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
