// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ExportVectorEnrichmentJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Vector Enrichment job being exported.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The creation time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The Amazon Resource Name (ARN) of the IAM role with permission to upload to the location in OutputConfig.
     */
    public val executionRoleArn: kotlin.String = requireNotNull(builder.executionRoleArn) { "A non-null value must be provided for executionRoleArn" }
    /**
     * The status of the results the Vector Enrichment job being exported.
     */
    public val exportStatus: aws.sdk.kotlin.services.sagemakergeospatial.model.VectorEnrichmentJobExportStatus = requireNotNull(builder.exportStatus) { "A non-null value must be provided for exportStatus" }
    /**
     * Output location information for exporting Vector Enrichment Job results.
     */
    public val outputConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig? = builder.outputConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportVectorEnrichmentJobResponse(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("executionRoleArn=$executionRoleArn,")
        append("exportStatus=$exportStatus,")
        append("outputConfig=$outputConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (executionRoleArn.hashCode())
        result = 31 * result + (exportStatus.hashCode())
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportVectorEnrichmentJobResponse

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (exportStatus != other.exportStatus) return false
        if (outputConfig != other.outputConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Vector Enrichment job being exported.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role with permission to upload to the location in OutputConfig.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The status of the results the Vector Enrichment job being exported.
         */
        public var exportStatus: aws.sdk.kotlin.services.sagemakergeospatial.model.VectorEnrichmentJobExportStatus? = null
        /**
         * Output location information for exporting Vector Enrichment Job results.
         */
        public var outputConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.executionRoleArn = x.executionRoleArn
            this.exportStatus = x.exportStatus
            this.outputConfig = x.outputConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse = ExportVectorEnrichmentJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (executionRoleArn == null) executionRoleArn = ""
            if (exportStatus == null) exportStatus = VectorEnrichmentJobExportStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
