// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.sagemakergeospatial.auth.DefaultSageMakerGeospatialAuthSchemeProvider
import aws.sdk.kotlin.services.sagemakergeospatial.auth.SageMakerGeospatialAuthSchemeProvider
import aws.sdk.kotlin.services.sagemakergeospatial.endpoints.DefaultSageMakerGeospatialEndpointProvider
import aws.sdk.kotlin.services.sagemakergeospatial.endpoints.SageMakerGeospatialEndpointParameters
import aws.sdk.kotlin.services.sagemakergeospatial.endpoints.SageMakerGeospatialEndpointProvider
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetRasterDataCollectionRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetRasterDataCollectionResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetTileRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetTileResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobsResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.TagResourceRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.TagResourceResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.UntagResourceRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SageMaker Geospatial"
public const val SdkVersion: String = "1.3.48"
public const val ServiceApiVersion: String = "2020-05-27"

/**
 * Provides APIs for creating and managing SageMaker geospatial resources.
 */
public interface SageMakerGeospatialClient : SdkClient {
    /**
     * SageMakerGeospatialClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SageMakerGeospatialClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "SageMakerGeospatial",
                "SAGEMAKER_GEOSPATIAL",
                "sagemaker_geospatial",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SageMakerGeospatialClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SageMakerGeospatialClient = DefaultSageMakerGeospatialClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SageMakerGeospatialEndpointProvider = builder.endpointProvider ?: DefaultSageMakerGeospatialEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SageMakerGeospatialAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSageMakerGeospatialAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SageMaker Geospatial"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SageMakerGeospatialEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SageMakerGeospatialAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Use this operation to delete an Earth Observation job.
     */
    public suspend fun deleteEarthObservationJob(input: DeleteEarthObservationJobRequest): DeleteEarthObservationJobResponse

    /**
     * Use this operation to delete a Vector Enrichment job.
     */
    public suspend fun deleteVectorEnrichmentJob(input: DeleteVectorEnrichmentJobRequest): DeleteVectorEnrichmentJobResponse

    /**
     * Use this operation to export results of an Earth Observation job and optionally source images used as input to the EOJ to an Amazon S3 location.
     */
    public suspend fun exportEarthObservationJob(input: ExportEarthObservationJobRequest): ExportEarthObservationJobResponse

    /**
     * Use this operation to copy results of a Vector Enrichment job to an Amazon S3 location.
     */
    public suspend fun exportVectorEnrichmentJob(input: ExportVectorEnrichmentJobRequest): ExportVectorEnrichmentJobResponse

    /**
     * Get the details for a previously initiated Earth Observation job.
     */
    public suspend fun getEarthObservationJob(input: GetEarthObservationJobRequest): GetEarthObservationJobResponse

    /**
     * Use this operation to get details of a specific raster data collection.
     */
    public suspend fun getRasterDataCollection(input: GetRasterDataCollectionRequest): GetRasterDataCollectionResponse

    /**
     * Gets a web mercator tile for the given Earth Observation job.
     */
    public suspend fun <T> getTile(input: GetTileRequest, block: suspend (GetTileResponse) -> T): T

    /**
     * Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN).
     */
    public suspend fun getVectorEnrichmentJob(input: GetVectorEnrichmentJobRequest): GetVectorEnrichmentJobResponse

    /**
     * Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services account.
     */
    public suspend fun listEarthObservationJobs(input: ListEarthObservationJobsRequest = ListEarthObservationJobsRequest { }): ListEarthObservationJobsResponse

    /**
     * Use this operation to get raster data collections.
     */
    public suspend fun listRasterDataCollections(input: ListRasterDataCollectionsRequest = ListRasterDataCollectionsRequest { }): ListRasterDataCollectionsResponse

    /**
     * Lists the tags attached to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of vector enrichment jobs.
     */
    public suspend fun listVectorEnrichmentJobs(input: ListVectorEnrichmentJobsRequest = ListVectorEnrichmentJobsRequest { }): ListVectorEnrichmentJobsResponse

    /**
     * Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching the selected filters.
     */
    public suspend fun searchRasterDataCollection(input: SearchRasterDataCollectionRequest): SearchRasterDataCollectionResponse

    /**
     * Use this operation to create an Earth observation job.
     */
    public suspend fun startEarthObservationJob(input: StartEarthObservationJobRequest): StartEarthObservationJobResponse

    /**
     * Creates a Vector Enrichment job for the supplied job type. Currently, there are two supported job types: reverse geocoding and map matching.
     */
    public suspend fun startVectorEnrichmentJob(input: StartVectorEnrichmentJobRequest): StartVectorEnrichmentJobResponse

    /**
     * Use this operation to stop an existing earth observation job.
     */
    public suspend fun stopEarthObservationJob(input: StopEarthObservationJobRequest): StopEarthObservationJobResponse

    /**
     * Stops the Vector Enrichment job for a given job ARN.
     */
    public suspend fun stopVectorEnrichmentJob(input: StopVectorEnrichmentJobRequest): StopVectorEnrichmentJobResponse

    /**
     * The resource you want to tag.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * The resource you want to untag.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SageMakerGeospatialClient.withConfig(block: SageMakerGeospatialClient.Config.Builder.() -> Unit): SageMakerGeospatialClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSageMakerGeospatialClient(newConfig)
}

/**
 * Use this operation to delete an Earth Observation job.
 */
public suspend inline fun SageMakerGeospatialClient.deleteEarthObservationJob(crossinline block: DeleteEarthObservationJobRequest.Builder.() -> Unit): DeleteEarthObservationJobResponse = deleteEarthObservationJob(DeleteEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Use this operation to delete a Vector Enrichment job.
 */
public suspend inline fun SageMakerGeospatialClient.deleteVectorEnrichmentJob(crossinline block: DeleteVectorEnrichmentJobRequest.Builder.() -> Unit): DeleteVectorEnrichmentJobResponse = deleteVectorEnrichmentJob(DeleteVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * Use this operation to export results of an Earth Observation job and optionally source images used as input to the EOJ to an Amazon S3 location.
 */
public suspend inline fun SageMakerGeospatialClient.exportEarthObservationJob(crossinline block: ExportEarthObservationJobRequest.Builder.() -> Unit): ExportEarthObservationJobResponse = exportEarthObservationJob(ExportEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Use this operation to copy results of a Vector Enrichment job to an Amazon S3 location.
 */
public suspend inline fun SageMakerGeospatialClient.exportVectorEnrichmentJob(crossinline block: ExportVectorEnrichmentJobRequest.Builder.() -> Unit): ExportVectorEnrichmentJobResponse = exportVectorEnrichmentJob(ExportVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * Get the details for a previously initiated Earth Observation job.
 */
public suspend inline fun SageMakerGeospatialClient.getEarthObservationJob(crossinline block: GetEarthObservationJobRequest.Builder.() -> Unit): GetEarthObservationJobResponse = getEarthObservationJob(GetEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Use this operation to get details of a specific raster data collection.
 */
public suspend inline fun SageMakerGeospatialClient.getRasterDataCollection(crossinline block: GetRasterDataCollectionRequest.Builder.() -> Unit): GetRasterDataCollectionResponse = getRasterDataCollection(GetRasterDataCollectionRequest.Builder().apply(block).build())

/**
 * Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN).
 */
public suspend inline fun SageMakerGeospatialClient.getVectorEnrichmentJob(crossinline block: GetVectorEnrichmentJobRequest.Builder.() -> Unit): GetVectorEnrichmentJobResponse = getVectorEnrichmentJob(GetVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services account.
 */
public suspend inline fun SageMakerGeospatialClient.listEarthObservationJobs(crossinline block: ListEarthObservationJobsRequest.Builder.() -> Unit): ListEarthObservationJobsResponse = listEarthObservationJobs(ListEarthObservationJobsRequest.Builder().apply(block).build())

/**
 * Use this operation to get raster data collections.
 */
public suspend inline fun SageMakerGeospatialClient.listRasterDataCollections(crossinline block: ListRasterDataCollectionsRequest.Builder.() -> Unit): ListRasterDataCollectionsResponse = listRasterDataCollections(ListRasterDataCollectionsRequest.Builder().apply(block).build())

/**
 * Lists the tags attached to the resource.
 */
public suspend inline fun SageMakerGeospatialClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves a list of vector enrichment jobs.
 */
public suspend inline fun SageMakerGeospatialClient.listVectorEnrichmentJobs(crossinline block: ListVectorEnrichmentJobsRequest.Builder.() -> Unit): ListVectorEnrichmentJobsResponse = listVectorEnrichmentJobs(ListVectorEnrichmentJobsRequest.Builder().apply(block).build())

/**
 * Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching the selected filters.
 */
public suspend inline fun SageMakerGeospatialClient.searchRasterDataCollection(crossinline block: SearchRasterDataCollectionRequest.Builder.() -> Unit): SearchRasterDataCollectionResponse = searchRasterDataCollection(SearchRasterDataCollectionRequest.Builder().apply(block).build())

/**
 * Use this operation to create an Earth observation job.
 */
public suspend inline fun SageMakerGeospatialClient.startEarthObservationJob(crossinline block: StartEarthObservationJobRequest.Builder.() -> Unit): StartEarthObservationJobResponse = startEarthObservationJob(StartEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Creates a Vector Enrichment job for the supplied job type. Currently, there are two supported job types: reverse geocoding and map matching.
 */
public suspend inline fun SageMakerGeospatialClient.startVectorEnrichmentJob(crossinline block: StartVectorEnrichmentJobRequest.Builder.() -> Unit): StartVectorEnrichmentJobResponse = startVectorEnrichmentJob(StartVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * Use this operation to stop an existing earth observation job.
 */
public suspend inline fun SageMakerGeospatialClient.stopEarthObservationJob(crossinline block: StopEarthObservationJobRequest.Builder.() -> Unit): StopEarthObservationJobResponse = stopEarthObservationJob(StopEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Stops the Vector Enrichment job for a given job ARN.
 */
public suspend inline fun SageMakerGeospatialClient.stopVectorEnrichmentJob(crossinline block: StopVectorEnrichmentJobRequest.Builder.() -> Unit): StopVectorEnrichmentJobResponse = stopVectorEnrichmentJob(StopVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * The resource you want to tag.
 */
public suspend inline fun SageMakerGeospatialClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * The resource you want to untag.
 */
public suspend inline fun SageMakerGeospatialClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
