// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure representing input configuration of ZonalStatistics operation.
 */
public class ZonalStatisticsConfigInput private constructor(builder: Builder) {
    /**
     * List of zonal statistics to compute.
     */
    public val statistics: List<ZonalStatistics> = requireNotNull(builder.statistics) { "A non-null value must be provided for statistics" }
    /**
     * Bands used in the operation. If no target bands are specified, it uses all bands available input.
     */
    public val targetBands: List<String>? = builder.targetBands
    /**
     * The Amazon S3 path pointing to the GeoJSON containing the polygonal zones.
     */
    public val zoneS3Path: kotlin.String = requireNotNull(builder.zoneS3Path) { "A non-null value must be provided for zoneS3Path" }
    /**
     * The Amazon Resource Name (ARN) or an ID of a Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to decrypt your output artifacts with Amazon S3 server-side encryption. The SageMaker execution role must have `kms:GenerateDataKey` permission.
     *
     * The `KmsKeyId` can be any of the following formats:
     * + // KMS Key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + // Amazon Resource Name (ARN) of a KMS Key`"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"`
     *
     * For more information about key identifiers, see [Key identifiers (KeyID)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id) in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
     */
    public val zoneS3PathKmsKeyId: kotlin.String? = builder.zoneS3PathKmsKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakergeospatial.model.ZonalStatisticsConfigInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ZonalStatisticsConfigInput(")
        append("statistics=$statistics,")
        append("targetBands=$targetBands,")
        append("zoneS3Path=$zoneS3Path,")
        append("zoneS3PathKmsKeyId=$zoneS3PathKmsKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = statistics.hashCode()
        result = 31 * result + (targetBands?.hashCode() ?: 0)
        result = 31 * result + (zoneS3Path.hashCode())
        result = 31 * result + (zoneS3PathKmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ZonalStatisticsConfigInput

        if (statistics != other.statistics) return false
        if (targetBands != other.targetBands) return false
        if (zoneS3Path != other.zoneS3Path) return false
        if (zoneS3PathKmsKeyId != other.zoneS3PathKmsKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakergeospatial.model.ZonalStatisticsConfigInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * List of zonal statistics to compute.
         */
        public var statistics: List<ZonalStatistics>? = null
        /**
         * Bands used in the operation. If no target bands are specified, it uses all bands available input.
         */
        public var targetBands: List<String>? = null
        /**
         * The Amazon S3 path pointing to the GeoJSON containing the polygonal zones.
         */
        public var zoneS3Path: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) or an ID of a Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to decrypt your output artifacts with Amazon S3 server-side encryption. The SageMaker execution role must have `kms:GenerateDataKey` permission.
         *
         * The `KmsKeyId` can be any of the following formats:
         * + // KMS Key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + // Amazon Resource Name (ARN) of a KMS Key`"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"`
         *
         * For more information about key identifiers, see [Key identifiers (KeyID)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id) in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
         */
        public var zoneS3PathKmsKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakergeospatial.model.ZonalStatisticsConfigInput) : this() {
            this.statistics = x.statistics
            this.targetBands = x.targetBands
            this.zoneS3Path = x.zoneS3Path
            this.zoneS3PathKmsKeyId = x.zoneS3PathKmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakergeospatial.model.ZonalStatisticsConfigInput = ZonalStatisticsConfigInput(this)

        internal fun correctErrors(): Builder {
            if (statistics == null) statistics = emptyList()
            if (zoneS3Path == null) zoneS3Path = ""
            return this
        }
    }
}
