// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetEarthObservationJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Earth Observation job.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The creation time of the initiated Earth Observation job.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The duration of Earth Observation job, in seconds.
     */
    public val durationInSeconds: kotlin.Int = requireNotNull(builder.durationInSeconds) { "A non-null value must be provided for durationInSeconds" }
    /**
     * Details about the errors generated during the Earth Observation job.
     */
    public val errorDetails: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobErrorDetails? = builder.errorDetails
    /**
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * Details about the errors generated during ExportEarthObservationJob.
     */
    public val exportErrorDetails: aws.sdk.kotlin.services.sagemakergeospatial.model.ExportErrorDetails? = builder.exportErrorDetails
    /**
     * The status of the Earth Observation job.
     */
    public val exportStatus: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobExportStatus? = builder.exportStatus
    /**
     * Input data for the Earth Observation job.
     */
    public val inputConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput? = builder.inputConfig
    /**
     * An object containing information about the job configuration.
     */
    public val jobConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.JobConfigInput? = builder.jobConfig
    /**
     * The Key Management Service key ID for server-side encryption.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the Earth Observation job.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Bands available in the output of an operation.
     */
    public val outputBands: List<OutputBand>? = builder.outputBands
    /**
     * The status of a previously initiated Earth Observation job.
     */
    public val status: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Each tag consists of a key and a value.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEarthObservationJobResponse(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("durationInSeconds=$durationInSeconds,")
        append("errorDetails=$errorDetails,")
        append("executionRoleArn=$executionRoleArn,")
        append("exportErrorDetails=$exportErrorDetails,")
        append("exportStatus=$exportStatus,")
        append("inputConfig=$inputConfig,")
        append("jobConfig=$jobConfig,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("outputBands=$outputBands,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (durationInSeconds)
        result = 31 * result + (errorDetails?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (exportErrorDetails?.hashCode() ?: 0)
        result = 31 * result + (exportStatus?.hashCode() ?: 0)
        result = 31 * result + (inputConfig?.hashCode() ?: 0)
        result = 31 * result + (jobConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (outputBands?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEarthObservationJobResponse

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (durationInSeconds != other.durationInSeconds) return false
        if (errorDetails != other.errorDetails) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (exportErrorDetails != other.exportErrorDetails) return false
        if (exportStatus != other.exportStatus) return false
        if (inputConfig != other.inputConfig) return false
        if (jobConfig != other.jobConfig) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (outputBands != other.outputBands) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Earth Observation job.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation time of the initiated Earth Observation job.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The duration of Earth Observation job, in seconds.
         */
        public var durationInSeconds: kotlin.Int? = null
        /**
         * Details about the errors generated during the Earth Observation job.
         */
        public var errorDetails: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobErrorDetails? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * Details about the errors generated during ExportEarthObservationJob.
         */
        public var exportErrorDetails: aws.sdk.kotlin.services.sagemakergeospatial.model.ExportErrorDetails? = null
        /**
         * The status of the Earth Observation job.
         */
        public var exportStatus: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobExportStatus? = null
        /**
         * Input data for the Earth Observation job.
         */
        public var inputConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput? = null
        /**
         * An object containing information about the job configuration.
         */
        public var jobConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.JobConfigInput? = null
        /**
         * The Key Management Service key ID for server-side encryption.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the Earth Observation job.
         */
        public var name: kotlin.String? = null
        /**
         * Bands available in the output of an operation.
         */
        public var outputBands: List<OutputBand>? = null
        /**
         * The status of a previously initiated Earth Observation job.
         */
        public var status: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobStatus? = null
        /**
         * Each tag consists of a key and a value.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobResponse) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.durationInSeconds = x.durationInSeconds
            this.errorDetails = x.errorDetails
            this.executionRoleArn = x.executionRoleArn
            this.exportErrorDetails = x.exportErrorDetails
            this.exportStatus = x.exportStatus
            this.inputConfig = x.inputConfig
            this.jobConfig = x.jobConfig
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.outputBands = x.outputBands
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobResponse = GetEarthObservationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobErrorDetails] inside the given [block]
         */
        public fun errorDetails(block: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobErrorDetails.Builder.() -> kotlin.Unit) {
            this.errorDetails = aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobErrorDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemakergeospatial.model.ExportErrorDetails] inside the given [block]
         */
        public fun exportErrorDetails(block: aws.sdk.kotlin.services.sagemakergeospatial.model.ExportErrorDetails.Builder.() -> kotlin.Unit) {
            this.exportErrorDetails = aws.sdk.kotlin.services.sagemakergeospatial.model.ExportErrorDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput] inside the given [block]
         */
        public fun inputConfig(block: aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput.Builder.() -> kotlin.Unit) {
            this.inputConfig = aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (durationInSeconds == null) durationInSeconds = 0
            if (name == null) name = ""
            if (status == null) status = EarthObservationJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
