// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.paginators

import aws.sdk.kotlin.services.sagemakergeospatial.SageMakerGeospatialClient
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobsResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.RasterDataCollectionMetadata
import aws.sdk.kotlin.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListEarthObservationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEarthObservationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEarthObservationJobsResponse]
 */
public fun SageMakerGeospatialClient.listEarthObservationJobsPaginated(initialRequest: ListEarthObservationJobsRequest = ListEarthObservationJobsRequest { }): Flow<ListEarthObservationJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEarthObservationJobsPaginated.listEarthObservationJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEarthObservationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEarthObservationJobsResponse]
 */
public fun SageMakerGeospatialClient.listEarthObservationJobsPaginated(block: ListEarthObservationJobsRequest.Builder.() -> Unit): Flow<ListEarthObservationJobsResponse> =
    listEarthObservationJobsPaginated(ListEarthObservationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEarthObservationJobsPaginated]
 * to access the nested member [ListEarthObservationJobOutputConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEarthObservationJobOutputConfig]
 */
@JvmName("listEarthObservationJobsResponseListEarthObservationJobOutputConfig")
public fun Flow<ListEarthObservationJobsResponse>.earthObservationJobSummaries(): Flow<ListEarthObservationJobOutputConfig> =
    transform() { response ->
        response.earthObservationJobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRasterDataCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRasterDataCollectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRasterDataCollectionsResponse]
 */
public fun SageMakerGeospatialClient.listRasterDataCollectionsPaginated(initialRequest: ListRasterDataCollectionsRequest = ListRasterDataCollectionsRequest { }): Flow<ListRasterDataCollectionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRasterDataCollectionsPaginated.listRasterDataCollections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRasterDataCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRasterDataCollectionsResponse]
 */
public fun SageMakerGeospatialClient.listRasterDataCollectionsPaginated(block: ListRasterDataCollectionsRequest.Builder.() -> Unit): Flow<ListRasterDataCollectionsResponse> =
    listRasterDataCollectionsPaginated(ListRasterDataCollectionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRasterDataCollectionsPaginated]
 * to access the nested member [RasterDataCollectionMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RasterDataCollectionMetadata]
 */
@JvmName("listRasterDataCollectionsResponseRasterDataCollectionMetadata")
public fun Flow<ListRasterDataCollectionsResponse>.rasterDataCollectionSummaries(): Flow<RasterDataCollectionMetadata> =
    transform() { response ->
        response.rasterDataCollectionSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVectorEnrichmentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVectorEnrichmentJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVectorEnrichmentJobsResponse]
 */
public fun SageMakerGeospatialClient.listVectorEnrichmentJobsPaginated(initialRequest: ListVectorEnrichmentJobsRequest = ListVectorEnrichmentJobsRequest { }): Flow<ListVectorEnrichmentJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVectorEnrichmentJobsPaginated.listVectorEnrichmentJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVectorEnrichmentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVectorEnrichmentJobsResponse]
 */
public fun SageMakerGeospatialClient.listVectorEnrichmentJobsPaginated(block: ListVectorEnrichmentJobsRequest.Builder.() -> Unit): Flow<ListVectorEnrichmentJobsResponse> =
    listVectorEnrichmentJobsPaginated(ListVectorEnrichmentJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVectorEnrichmentJobsPaginated]
 * to access the nested member [ListVectorEnrichmentJobOutputConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVectorEnrichmentJobOutputConfig]
 */
@JvmName("listVectorEnrichmentJobsResponseListVectorEnrichmentJobOutputConfig")
public fun Flow<ListVectorEnrichmentJobsResponse>.vectorEnrichmentJobSummaries(): Flow<ListVectorEnrichmentJobOutputConfig> =
    transform() { response ->
        response.vectorEnrichmentJobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchRasterDataCollectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchRasterDataCollectionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchRasterDataCollectionResponse]
 */
public fun SageMakerGeospatialClient.searchRasterDataCollectionPaginated(initialRequest: SearchRasterDataCollectionRequest): Flow<SearchRasterDataCollectionResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchRasterDataCollectionPaginated.searchRasterDataCollection(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchRasterDataCollectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchRasterDataCollectionResponse]
 */
public fun SageMakerGeospatialClient.searchRasterDataCollectionPaginated(block: SearchRasterDataCollectionRequest.Builder.() -> Unit): Flow<SearchRasterDataCollectionResponse> =
    searchRasterDataCollectionPaginated(SearchRasterDataCollectionRequest.Builder().apply(block).build())
