// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input structure for Raster Data Collection Query containing the Area of Interest, TimeRange Filters, and Property Filters.
 */
public class RasterDataCollectionQueryInput private constructor(builder: Builder) {
    /**
     * The area of interest being queried for the raster data collection.
     */
    public val areaOfInterest: aws.sdk.kotlin.services.sagemakergeospatial.model.AreaOfInterest? = builder.areaOfInterest
    /**
     * The list of Property filters used in the Raster Data Collection Query.
     */
    public val propertyFilters: aws.sdk.kotlin.services.sagemakergeospatial.model.PropertyFilters? = builder.propertyFilters
    /**
     * The Amazon Resource Name (ARN) of the raster data collection.
     */
    public val rasterDataCollectionArn: kotlin.String = requireNotNull(builder.rasterDataCollectionArn) { "A non-null value must be provided for rasterDataCollectionArn" }
    /**
     * The TimeRange Filter used in the RasterDataCollection Query.
     */
    public val timeRangeFilter: aws.sdk.kotlin.services.sagemakergeospatial.model.TimeRangeFilterInput? = builder.timeRangeFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakergeospatial.model.RasterDataCollectionQueryInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RasterDataCollectionQueryInput(")
        append("areaOfInterest=$areaOfInterest,")
        append("propertyFilters=$propertyFilters,")
        append("rasterDataCollectionArn=$rasterDataCollectionArn,")
        append("timeRangeFilter=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = areaOfInterest?.hashCode() ?: 0
        result = 31 * result + (propertyFilters?.hashCode() ?: 0)
        result = 31 * result + (rasterDataCollectionArn.hashCode())
        result = 31 * result + (timeRangeFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RasterDataCollectionQueryInput

        if (areaOfInterest != other.areaOfInterest) return false
        if (propertyFilters != other.propertyFilters) return false
        if (rasterDataCollectionArn != other.rasterDataCollectionArn) return false
        if (timeRangeFilter != other.timeRangeFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakergeospatial.model.RasterDataCollectionQueryInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The area of interest being queried for the raster data collection.
         */
        public var areaOfInterest: aws.sdk.kotlin.services.sagemakergeospatial.model.AreaOfInterest? = null
        /**
         * The list of Property filters used in the Raster Data Collection Query.
         */
        public var propertyFilters: aws.sdk.kotlin.services.sagemakergeospatial.model.PropertyFilters? = null
        /**
         * The Amazon Resource Name (ARN) of the raster data collection.
         */
        public var rasterDataCollectionArn: kotlin.String? = null
        /**
         * The TimeRange Filter used in the RasterDataCollection Query.
         */
        public var timeRangeFilter: aws.sdk.kotlin.services.sagemakergeospatial.model.TimeRangeFilterInput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakergeospatial.model.RasterDataCollectionQueryInput) : this() {
            this.areaOfInterest = x.areaOfInterest
            this.propertyFilters = x.propertyFilters
            this.rasterDataCollectionArn = x.rasterDataCollectionArn
            this.timeRangeFilter = x.timeRangeFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakergeospatial.model.RasterDataCollectionQueryInput = RasterDataCollectionQueryInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemakergeospatial.model.PropertyFilters] inside the given [block]
         */
        public fun propertyFilters(block: aws.sdk.kotlin.services.sagemakergeospatial.model.PropertyFilters.Builder.() -> kotlin.Unit) {
            this.propertyFilters = aws.sdk.kotlin.services.sagemakergeospatial.model.PropertyFilters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemakergeospatial.model.TimeRangeFilterInput] inside the given [block]
         */
        public fun timeRangeFilter(block: aws.sdk.kotlin.services.sagemakergeospatial.model.TimeRangeFilterInput.Builder.() -> kotlin.Unit) {
            this.timeRangeFilter = aws.sdk.kotlin.services.sagemakergeospatial.model.TimeRangeFilterInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (rasterDataCollectionArn == null) rasterDataCollectionArn = ""
            return this
        }
    }
}
