// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.model

import aws.smithy.kotlin.runtime.time.Instant

public class ExportEarthObservationJobResponse private constructor(builder: Builder) {
    /**
     * The output Amazon Resource Name (ARN) of the Earth Observation job being exported.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The creation time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     */
    public val executionRoleArn: kotlin.String = requireNotNull(builder.executionRoleArn) { "A non-null value must be provided for executionRoleArn" }
    /**
     * The source images provided to the Earth Observation job being exported.
     */
    public val exportSourceImages: kotlin.Boolean? = builder.exportSourceImages
    /**
     * The status of the results of the Earth Observation job being exported.
     */
    public val exportStatus: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobExportStatus = requireNotNull(builder.exportStatus) { "A non-null value must be provided for exportStatus" }
    /**
     * An object containing information about the output file.
     */
    public val outputConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.OutputConfigInput? = builder.outputConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakergeospatial.model.ExportEarthObservationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportEarthObservationJobResponse(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("executionRoleArn=$executionRoleArn,")
        append("exportSourceImages=$exportSourceImages,")
        append("exportStatus=$exportStatus,")
        append("outputConfig=$outputConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (executionRoleArn.hashCode())
        result = 31 * result + (exportSourceImages?.hashCode() ?: 0)
        result = 31 * result + (exportStatus.hashCode())
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportEarthObservationJobResponse

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (exportSourceImages != other.exportSourceImages) return false
        if (exportStatus != other.exportStatus) return false
        if (outputConfig != other.outputConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakergeospatial.model.ExportEarthObservationJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The output Amazon Resource Name (ARN) of the Earth Observation job being exported.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The source images provided to the Earth Observation job being exported.
         */
        public var exportSourceImages: kotlin.Boolean? = null
        /**
         * The status of the results of the Earth Observation job being exported.
         */
        public var exportStatus: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobExportStatus? = null
        /**
         * An object containing information about the output file.
         */
        public var outputConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.OutputConfigInput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakergeospatial.model.ExportEarthObservationJobResponse) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.executionRoleArn = x.executionRoleArn
            this.exportSourceImages = x.exportSourceImages
            this.exportStatus = x.exportStatus
            this.outputConfig = x.outputConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakergeospatial.model.ExportEarthObservationJobResponse = ExportEarthObservationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemakergeospatial.model.OutputConfigInput] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.sagemakergeospatial.model.OutputConfigInput.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemakergeospatial.model.OutputConfigInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (executionRoleArn == null) executionRoleArn = ""
            if (exportStatus == null) exportStatus = EarthObservationJobExportStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
