// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.model

import aws.smithy.kotlin.runtime.time.Instant

public class StartEarthObservationJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Earth Observation job.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The creation time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The duration of the session, in seconds.
     */
    public val durationInSeconds: kotlin.Int = requireNotNull(builder.durationInSeconds) { "A non-null value must be provided for durationInSeconds" }
    /**
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
     */
    public val executionRoleArn: kotlin.String = requireNotNull(builder.executionRoleArn) { "A non-null value must be provided for executionRoleArn" }
    /**
     * Input configuration information for the Earth Observation job.
     */
    public val inputConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput? = builder.inputConfig
    /**
     * An object containing information about the job configuration.
     */
    public val jobConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.JobConfigInput? = builder.jobConfig
    /**
     * The Key Management Service key ID for server-side encryption.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the Earth Observation job.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the Earth Observation job.
     */
    public val status: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Each tag consists of a key and a value.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakergeospatial.model.StartEarthObservationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartEarthObservationJobResponse(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("durationInSeconds=$durationInSeconds,")
        append("executionRoleArn=$executionRoleArn,")
        append("inputConfig=$inputConfig,")
        append("jobConfig=$jobConfig,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (durationInSeconds)
        result = 31 * result + (executionRoleArn.hashCode())
        result = 31 * result + (inputConfig?.hashCode() ?: 0)
        result = 31 * result + (jobConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartEarthObservationJobResponse

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (durationInSeconds != other.durationInSeconds) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (inputConfig != other.inputConfig) return false
        if (jobConfig != other.jobConfig) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakergeospatial.model.StartEarthObservationJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Earth Observation job.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The duration of the session, in seconds.
         */
        public var durationInSeconds: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * Input configuration information for the Earth Observation job.
         */
        public var inputConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput? = null
        /**
         * An object containing information about the job configuration.
         */
        public var jobConfig: aws.sdk.kotlin.services.sagemakergeospatial.model.JobConfigInput? = null
        /**
         * The Key Management Service key ID for server-side encryption.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the Earth Observation job.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the Earth Observation job.
         */
        public var status: aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobStatus? = null
        /**
         * Each tag consists of a key and a value.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakergeospatial.model.StartEarthObservationJobResponse) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.durationInSeconds = x.durationInSeconds
            this.executionRoleArn = x.executionRoleArn
            this.inputConfig = x.inputConfig
            this.jobConfig = x.jobConfig
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakergeospatial.model.StartEarthObservationJobResponse = StartEarthObservationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput] inside the given [block]
         */
        public fun inputConfig(block: aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput.Builder.() -> kotlin.Unit) {
            this.inputConfig = aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (durationInSeconds == null) durationInSeconds = 0
            if (executionRoleArn == null) executionRoleArn = ""
            if (name == null) name = ""
            if (status == null) status = EarthObservationJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
