// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial.transform

import aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobErrorDetails
import aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobExportStatus
import aws.sdk.kotlin.services.sagemakergeospatial.model.EarthObservationJobStatus
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportErrorDetails
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.InputConfigOutput
import aws.sdk.kotlin.services.sagemakergeospatial.model.JobConfigInput
import aws.sdk.kotlin.services.sagemakergeospatial.model.OutputBand
import aws.sdk.kotlin.services.sagemakergeospatial.model.SageMakerGeospatialException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetEarthObservationJobOperationDeserializer: HttpDeserialize<GetEarthObservationJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEarthObservationJobResponse {
        if (!response.status.isSuccess()) {
            throwGetEarthObservationJobError(context, response)
        }
        val builder = GetEarthObservationJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEarthObservationJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetEarthObservationJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerGeospatialException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerGeospatialException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEarthObservationJobOperationBody(builder: GetEarthObservationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DURATIONINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DurationInSeconds"))
    val ERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ErrorDetails"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionRoleArn"))
    val EXPORTERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExportErrorDetails"))
    val EXPORTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExportStatus"))
    val INPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputConfig"))
    val JOBCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("JobConfig"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OUTPUTBANDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OutputBands"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DURATIONINSECONDS_DESCRIPTOR)
        field(ERRORDETAILS_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(EXPORTERRORDETAILS_DESCRIPTOR)
        field(EXPORTSTATUS_DESCRIPTOR)
        field(INPUTCONFIG_DESCRIPTOR)
        field(JOBCONFIG_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OUTPUTBANDS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromIso8601(it) }
                DURATIONINSECONDS_DESCRIPTOR.index -> builder.durationInSeconds = deserializeInt()
                ERRORDETAILS_DESCRIPTOR.index -> builder.errorDetails = deserializeEarthObservationJobErrorDetailsDocument(deserializer)
                EXECUTIONROLEARN_DESCRIPTOR.index -> builder.executionRoleArn = deserializeString()
                EXPORTERRORDETAILS_DESCRIPTOR.index -> builder.exportErrorDetails = deserializeExportErrorDetailsDocument(deserializer)
                EXPORTSTATUS_DESCRIPTOR.index -> builder.exportStatus = deserializeString().let { EarthObservationJobExportStatus.fromValue(it) }
                INPUTCONFIG_DESCRIPTOR.index -> builder.inputConfig = deserializeInputConfigOutputDocument(deserializer)
                JOBCONFIG_DESCRIPTOR.index -> builder.jobConfig = deserializeJobConfigInputDocument(deserializer)
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OUTPUTBANDS_DESCRIPTOR.index -> builder.outputBands =
                    deserializer.deserializeList(OUTPUTBANDS_DESCRIPTOR) {
                        val col0 = mutableListOf<OutputBand>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOutputBandDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EarthObservationJobStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
