// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakergeospatial

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.sagemakergeospatial.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.sagemakergeospatial.endpoints.EndpointProvider
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetRasterDataCollectionRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetRasterDataCollectionResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetTileRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetTileResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.GetVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListEarthObservationJobsResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StartVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopEarthObservationJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopEarthObservationJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.StopVectorEnrichmentJobResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.TagResourceRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.TagResourceResponse
import aws.sdk.kotlin.services.sagemakergeospatial.model.UntagResourceRequest
import aws.sdk.kotlin.services.sagemakergeospatial.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * Provides APIs for creating and managing SageMaker geospatial resources.
 */
public interface SageMakerGeospatialClient : SdkClient {

    override val serviceName: String
        get() = "SageMaker Geospatial"
    /**
     * SageMakerGeospatialClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SageMakerGeospatialClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SageMakerGeospatialClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SageMakerGeospatialClient = DefaultSageMakerGeospatialClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "SageMaker Geospatial")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, IdempotencyTokenConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Use this operation to delete an Earth Observation job.
     */
    public suspend fun deleteEarthObservationJob(input: DeleteEarthObservationJobRequest): DeleteEarthObservationJobResponse

    /**
     * Use this operation to delete a Vector Enrichment job.
     */
    public suspend fun deleteVectorEnrichmentJob(input: DeleteVectorEnrichmentJobRequest): DeleteVectorEnrichmentJobResponse

    /**
     * Use this operation to export results of an Earth Observation job and optionally source images used as input to the EOJ to an S3 location.
     */
    public suspend fun exportEarthObservationJob(input: ExportEarthObservationJobRequest): ExportEarthObservationJobResponse

    /**
     * Use this operation to copy results of a Vector Enrichment job to an S3 location.
     */
    public suspend fun exportVectorEnrichmentJob(input: ExportVectorEnrichmentJobRequest): ExportVectorEnrichmentJobResponse

    /**
     * Get the details for a previously initiated Earth Observation job.
     */
    public suspend fun getEarthObservationJob(input: GetEarthObservationJobRequest): GetEarthObservationJobResponse

    /**
     * Use this operation to get details of a specific raster data collection.
     */
    public suspend fun getRasterDataCollection(input: GetRasterDataCollectionRequest): GetRasterDataCollectionResponse

    /**
     * Gets a web mercator tile for the given Earth Observation job.
     */
    public suspend fun <T> getTile(input: GetTileRequest, block: suspend (GetTileResponse) -> T): T

    /**
     * Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN).
     */
    public suspend fun getVectorEnrichmentJob(input: GetVectorEnrichmentJobRequest): GetVectorEnrichmentJobResponse

    /**
     * Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services account.
     */
    public suspend fun listEarthObservationJobs(input: ListEarthObservationJobsRequest = ListEarthObservationJobsRequest {}): ListEarthObservationJobsResponse

    /**
     * Use this operation to get raster data collections.
     */
    public suspend fun listRasterDataCollections(input: ListRasterDataCollectionsRequest = ListRasterDataCollectionsRequest {}): ListRasterDataCollectionsResponse

    /**
     * Lists the tags attached to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of vector enrichment jobs.
     */
    public suspend fun listVectorEnrichmentJobs(input: ListVectorEnrichmentJobsRequest = ListVectorEnrichmentJobsRequest {}): ListVectorEnrichmentJobsResponse

    /**
     * Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching the selected filters.
     */
    public suspend fun searchRasterDataCollection(input: SearchRasterDataCollectionRequest): SearchRasterDataCollectionResponse

    /**
     * Use this operation to create an Earth observation job.
     */
    public suspend fun startEarthObservationJob(input: StartEarthObservationJobRequest): StartEarthObservationJobResponse

    /**
     * Creates a Vector Enrichment job for the supplied job type. Currently, there are two supported job types: reverse geocoding and map matching.
     */
    public suspend fun startVectorEnrichmentJob(input: StartVectorEnrichmentJobRequest): StartVectorEnrichmentJobResponse

    /**
     * Use this operation to stop an existing earth observation job.
     */
    public suspend fun stopEarthObservationJob(input: StopEarthObservationJobRequest): StopEarthObservationJobResponse

    /**
     * Stops the Vector Enrichment job for a given job ARN.
     */
    public suspend fun stopVectorEnrichmentJob(input: StopVectorEnrichmentJobRequest): StopVectorEnrichmentJobResponse

    /**
     * The resource you want to tag.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * The resource you want to untag.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SageMakerGeospatialClient.withConfig(block: SageMakerGeospatialClient.Config.Builder.() -> Unit): SageMakerGeospatialClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSageMakerGeospatialClient(newConfig)
}

/**
 * Use this operation to delete an Earth Observation job.
 */
public suspend inline fun SageMakerGeospatialClient.deleteEarthObservationJob(crossinline block: DeleteEarthObservationJobRequest.Builder.() -> Unit): DeleteEarthObservationJobResponse = deleteEarthObservationJob(DeleteEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Use this operation to delete a Vector Enrichment job.
 */
public suspend inline fun SageMakerGeospatialClient.deleteVectorEnrichmentJob(crossinline block: DeleteVectorEnrichmentJobRequest.Builder.() -> Unit): DeleteVectorEnrichmentJobResponse = deleteVectorEnrichmentJob(DeleteVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * Use this operation to export results of an Earth Observation job and optionally source images used as input to the EOJ to an S3 location.
 */
public suspend inline fun SageMakerGeospatialClient.exportEarthObservationJob(crossinline block: ExportEarthObservationJobRequest.Builder.() -> Unit): ExportEarthObservationJobResponse = exportEarthObservationJob(ExportEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Use this operation to copy results of a Vector Enrichment job to an S3 location.
 */
public suspend inline fun SageMakerGeospatialClient.exportVectorEnrichmentJob(crossinline block: ExportVectorEnrichmentJobRequest.Builder.() -> Unit): ExportVectorEnrichmentJobResponse = exportVectorEnrichmentJob(ExportVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * Get the details for a previously initiated Earth Observation job.
 */
public suspend inline fun SageMakerGeospatialClient.getEarthObservationJob(crossinline block: GetEarthObservationJobRequest.Builder.() -> Unit): GetEarthObservationJobResponse = getEarthObservationJob(GetEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Use this operation to get details of a specific raster data collection.
 */
public suspend inline fun SageMakerGeospatialClient.getRasterDataCollection(crossinline block: GetRasterDataCollectionRequest.Builder.() -> Unit): GetRasterDataCollectionResponse = getRasterDataCollection(GetRasterDataCollectionRequest.Builder().apply(block).build())

/**
 * Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN).
 */
public suspend inline fun SageMakerGeospatialClient.getVectorEnrichmentJob(crossinline block: GetVectorEnrichmentJobRequest.Builder.() -> Unit): GetVectorEnrichmentJobResponse = getVectorEnrichmentJob(GetVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services account.
 */
public suspend inline fun SageMakerGeospatialClient.listEarthObservationJobs(crossinline block: ListEarthObservationJobsRequest.Builder.() -> Unit): ListEarthObservationJobsResponse = listEarthObservationJobs(ListEarthObservationJobsRequest.Builder().apply(block).build())

/**
 * Use this operation to get raster data collections.
 */
public suspend inline fun SageMakerGeospatialClient.listRasterDataCollections(crossinline block: ListRasterDataCollectionsRequest.Builder.() -> Unit): ListRasterDataCollectionsResponse = listRasterDataCollections(ListRasterDataCollectionsRequest.Builder().apply(block).build())

/**
 * Lists the tags attached to the resource.
 */
public suspend inline fun SageMakerGeospatialClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves a list of vector enrichment jobs.
 */
public suspend inline fun SageMakerGeospatialClient.listVectorEnrichmentJobs(crossinline block: ListVectorEnrichmentJobsRequest.Builder.() -> Unit): ListVectorEnrichmentJobsResponse = listVectorEnrichmentJobs(ListVectorEnrichmentJobsRequest.Builder().apply(block).build())

/**
 * Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching the selected filters.
 */
public suspend inline fun SageMakerGeospatialClient.searchRasterDataCollection(crossinline block: SearchRasterDataCollectionRequest.Builder.() -> Unit): SearchRasterDataCollectionResponse = searchRasterDataCollection(SearchRasterDataCollectionRequest.Builder().apply(block).build())

/**
 * Use this operation to create an Earth observation job.
 */
public suspend inline fun SageMakerGeospatialClient.startEarthObservationJob(crossinline block: StartEarthObservationJobRequest.Builder.() -> Unit): StartEarthObservationJobResponse = startEarthObservationJob(StartEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Creates a Vector Enrichment job for the supplied job type. Currently, there are two supported job types: reverse geocoding and map matching.
 */
public suspend inline fun SageMakerGeospatialClient.startVectorEnrichmentJob(crossinline block: StartVectorEnrichmentJobRequest.Builder.() -> Unit): StartVectorEnrichmentJobResponse = startVectorEnrichmentJob(StartVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * Use this operation to stop an existing earth observation job.
 */
public suspend inline fun SageMakerGeospatialClient.stopEarthObservationJob(crossinline block: StopEarthObservationJobRequest.Builder.() -> Unit): StopEarthObservationJobResponse = stopEarthObservationJob(StopEarthObservationJobRequest.Builder().apply(block).build())

/**
 * Stops the Vector Enrichment job for a given job ARN.
 */
public suspend inline fun SageMakerGeospatialClient.stopVectorEnrichmentJob(crossinline block: StopVectorEnrichmentJobRequest.Builder.() -> Unit): StopVectorEnrichmentJobResponse = stopVectorEnrichmentJob(StopVectorEnrichmentJobRequest.Builder().apply(block).build())

/**
 * The resource you want to tag.
 */
public suspend inline fun SageMakerGeospatialClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * The resource you want to untag.
 */
public suspend inline fun SageMakerGeospatialClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
