// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.FeatureValue
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.GetRecordResponse
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetRecordOperationDeserializer: HttpDeserialize<GetRecordResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRecordResponse {
        if (!response.status.isSuccess()) {
            throwGetRecordError(context, response)
        }
        val builder = GetRecordResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRecordOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRecordError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerFeatureStoreRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessForbidden" -> AccessForbiddenDeserializer().deserialize(context, wrappedResponse)
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedResponse)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerFeatureStoreRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRecordOperationBody(builder: GetRecordResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RECORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Record"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RECORD_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RECORD_DESCRIPTOR.index -> builder.record =
                    deserializer.deserializeList(RECORD_DESCRIPTOR) {
                        val col0 = mutableListOf<FeatureValue>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFeatureValueDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
