// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.DeleteRecordResponse
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteRecordOperationDeserializer: HttpDeserialize<DeleteRecordResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteRecordResponse {
        if (!response.status.isSuccess()) {
            throwDeleteRecordError(context, response)
        }
        val builder = DeleteRecordResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteRecordError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerFeatureStoreRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessForbidden" -> AccessForbiddenDeserializer().deserialize(context, wrappedResponse)
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedResponse)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerFeatureStoreRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
