// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model



public class PutRecordRequest private constructor(builder: Builder) {
    /**
     * The name of the feature group that you want to insert the record into.
     */
    public val featureGroupName: kotlin.String? = requireNotNull(builder.featureGroupName) { "A non-null value must be provided for featureGroupName" }
    /**
     * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the feature values, do the following:
     * + Use `GetRecord` to retrieve the latest record.
     * + Update the record returned from `GetRecord`.
     * + Use `PutRecord` to update feature values.
     */
    public val record: List<FeatureValue>? = builder.record
    /**
     * A list of stores to which you're adding the record. By default, Feature Store adds the record to all of the stores that you're using for the `FeatureGroup`.
     */
    public val targetStores: List<TargetStore>? = builder.targetStores

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.PutRecordRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRecordRequest(")
        append("featureGroupName=$featureGroupName,")
        append("record=$record,")
        append("targetStores=$targetStores")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = featureGroupName?.hashCode() ?: 0
        result = 31 * result + (record?.hashCode() ?: 0)
        result = 31 * result + (targetStores?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRecordRequest

        if (featureGroupName != other.featureGroupName) return false
        if (record != other.record) return false
        if (targetStores != other.targetStores) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.PutRecordRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the feature group that you want to insert the record into.
         */
        public var featureGroupName: kotlin.String? = null
        /**
         * List of FeatureValues to be inserted. This will be a full over-write. If you only want to update few of the feature values, do the following:
         * + Use `GetRecord` to retrieve the latest record.
         * + Update the record returned from `GetRecord`.
         * + Use `PutRecord` to update feature values.
         */
        public var record: List<FeatureValue>? = null
        /**
         * A list of stores to which you're adding the record. By default, Feature Store adds the record to all of the stores that you're using for the `FeatureGroup`.
         */
        public var targetStores: List<TargetStore>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.PutRecordRequest) : this() {
            this.featureGroupName = x.featureGroupName
            this.record = x.record
            this.targetStores = x.targetStores
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.PutRecordRequest = PutRecordRequest(this)
    }
}
