// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.serde

import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.DeleteRecordResponse
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteRecordOperationDeserializer: HttpDeserializer.NonStreaming<DeleteRecordResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteRecordResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteRecordError(context, call, payload)
        }
        val builder = DeleteRecordResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteRecordError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerFeatureStoreRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessForbidden" -> AccessForbiddenDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerFeatureStoreRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
