// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.serde

import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.PutRecordResponse
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutRecordOperationDeserializer: HttpDeserialize<PutRecordResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutRecordResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutRecordError(context, call)
        }
        val builder = PutRecordResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutRecordError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerFeatureStoreRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessForbidden" -> AccessForbiddenDeserializer().deserialize(context, wrappedCall)
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedCall)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerFeatureStoreRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
