// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.serde

import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetRecordOperationDeserializer: HttpDeserialize<BatchGetRecordResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BatchGetRecordResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetRecordError(context, call)
        }
        val builder = BatchGetRecordResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetRecordOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwBatchGetRecordError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerFeatureStoreRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessForbidden" -> AccessForbiddenDeserializer().deserialize(context, wrappedCall)
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedCall)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerFeatureStoreRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetRecordOperationBody(builder: BatchGetRecordResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Errors"))
    val RECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Records"))
    val UNPROCESSEDIDENTIFIERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedIdentifiers"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORS_DESCRIPTOR)
        field(RECORDS_DESCRIPTOR)
        field(UNPROCESSEDIDENTIFIERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetRecordError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetRecordErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RECORDS_DESCRIPTOR.index -> builder.records =
                    deserializer.deserializeList(RECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetRecordResultDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetRecordResultDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDIDENTIFIERS_DESCRIPTOR.index -> builder.unprocessedIdentifiers =
                    deserializer.deserializeList(UNPROCESSEDIDENTIFIERS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetRecordIdentifier>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetRecordIdentifierDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
