// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerfeaturestoreruntime

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.auth.SageMakerFeatureStoreRuntimeAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.auth.SageMakerFeatureStoreRuntimeIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.model.*
import aws.sdk.kotlin.services.sagemakerfeaturestoreruntime.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.util.attributesOf
import aws.smithy.kotlin.runtime.util.putIfAbsent
import aws.smithy.kotlin.runtime.util.putIfAbsentNotNull


public const val ServiceApiVersion: String = "2020-07-01"

internal class DefaultSageMakerFeatureStoreRuntimeClient(override val config: SageMakerFeatureStoreRuntimeClient.Config) : SageMakerFeatureStoreRuntimeClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = SageMakerFeatureStoreRuntimeIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "sagemaker")
        }
        toMap()
    }
    private val authSchemeAdapter = SageMakerFeatureStoreRuntimeAuthSchemeProviderAdapter(config.authSchemeProvider)
    private val telemetryScope = "aws.sdk.kotlin.services.sagemakerfeaturestoreruntime"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Retrieves a batch of `Records` from a `FeatureGroup`.
     */
    override suspend fun batchGetRecord(input: BatchGetRecordRequest): BatchGetRecordResponse {
        val op = SdkHttpOperation.build<BatchGetRecordRequest, BatchGetRecordResponse> {
            serializer = BatchGetRecordOperationSerializer()
            deserializer = BatchGetRecordOperationDeserializer()
            operationName = "BatchGetRecord"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a `Record` from a `FeatureGroup` in the `OnlineStore`. Feature Store supports both `SoftDelete` and `HardDelete`. For `SoftDelete` (default), feature columns are set to `null` and the record is no longer retrievable by `GetRecord` or `BatchGetRecord`. For `HardDelete`, the complete `Record` is removed from the `OnlineStore`. In both cases, Feature Store appends the deleted record marker to the `OfflineStore` with feature values set to `null`, `is_deleted` value set to `True`, and `EventTime` set to the delete input `EventTime`.
     *
     * Note that the `EventTime` specified in `DeleteRecord` should be set later than the `EventTime` of the existing record in the `OnlineStore` for that `RecordIdentifer`. If it is not, the deletion does not occur:
     * + For `SoftDelete`, the existing (undeleted) record remains in the `OnlineStore`, though the delete record marker is still written to the `OfflineStore`.
     * + `HardDelete` returns `EventTime`: `400 ValidationException` to indicate that the delete operation failed. No delete record marker is written to the `OfflineStore`.
     */
    override suspend fun deleteRecord(input: DeleteRecordRequest): DeleteRecordResponse {
        val op = SdkHttpOperation.build<DeleteRecordRequest, DeleteRecordResponse> {
            serializer = DeleteRecordOperationSerializer()
            deserializer = DeleteRecordOperationDeserializer()
            operationName = "DeleteRecord"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Use for `OnlineStore` serving from a `FeatureStore`. Only the latest records stored in the `OnlineStore` can be retrieved. If no Record with `RecordIdentifierValue` is found, then an empty result is returned.
     */
    override suspend fun getRecord(input: GetRecordRequest): GetRecordResponse {
        val op = SdkHttpOperation.build<GetRecordRequest, GetRecordResponse> {
            serializer = GetRecordOperationSerializer()
            deserializer = GetRecordOperationDeserializer()
            operationName = "GetRecord"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The `PutRecord` API is used to ingest a list of `Records` into your feature group.
     *
     * If a new record’s `EventTime` is greater, the new record is written to both the `OnlineStore` and `OfflineStore`. Otherwise, the record is a historic record and it is written only to the `OfflineStore`.
     *
     * You can specify the ingestion to be applied to the `OnlineStore`, `OfflineStore`, or both by using the `TargetStores` request parameter.
     *
     * You can set the ingested record to expire at a given time to live (TTL) duration after the record’s event time, `ExpiresAt` = `EventTime` + `TtlDuration`, by specifying the `TtlDuration` parameter. A record level `TtlDuration` is set when specifying the `TtlDuration` parameter using the `PutRecord` API call. If the input `TtlDuration` is `null` or unspecified, `TtlDuration` is set to the default feature group level `TtlDuration`. A record level `TtlDuration` supersedes the group level `TtlDuration`.
     */
    override suspend fun putRecord(input: PutRecordRequest): PutRecordResponse {
        val op = SdkHttpOperation.build<PutRecordRequest, PutRecordResponse> {
            serializer = PutRecordOperationSerializer()
            deserializer = PutRecordOperationDeserializer()
            operationName = "PutRecord"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "sagemaker")
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
