// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakera2iruntime.paginators

import aws.sdk.kotlin.services.sagemakera2iruntime.SageMakerA2IRuntimeClient
import aws.sdk.kotlin.services.sagemakera2iruntime.model.HumanLoopSummary
import aws.sdk.kotlin.services.sagemakera2iruntime.model.ListHumanLoopsRequest
import aws.sdk.kotlin.services.sagemakera2iruntime.model.ListHumanLoopsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListHumanLoopsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHumanLoopsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHumanLoopsResponse]
 */
public fun SageMakerA2IRuntimeClient.listHumanLoopsPaginated(initialRequest: ListHumanLoopsRequest): Flow<ListHumanLoopsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHumanLoopsPaginated.listHumanLoops(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListHumanLoopsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHumanLoopsResponse]
 */
public fun SageMakerA2IRuntimeClient.listHumanLoopsPaginated(block: ListHumanLoopsRequest.Builder.() -> Unit): Flow<ListHumanLoopsResponse> =
    listHumanLoopsPaginated(ListHumanLoopsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listHumanLoopsPaginated]
 * to access the nested member [HumanLoopSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HumanLoopSummary]
 */
@JvmName("listHumanLoopsResponseHumanLoopSummary")
public fun Flow<ListHumanLoopsResponse>.humanLoopSummaries(): Flow<HumanLoopSummary> =
    transform() { response ->
        response.humanLoopSummaries?.forEach {
            emit(it)
        }
    }
