// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakera2iruntime.endpoints.internal

import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.AwsBusinessMetric
import aws.sdk.kotlin.services.sagemakera2iruntime.SageMakerA2IRuntimeClient
import aws.sdk.kotlin.services.sagemakera2iruntime.endpoints.SageMakerA2IRuntimeEndpointParameters
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.businessmetrics.AccountIdBasedEndpointAccountId
import aws.smithy.kotlin.runtime.businessmetrics.ServiceEndpointOverride
import aws.smithy.kotlin.runtime.businessmetrics.SmithyBusinessMetric
import aws.smithy.kotlin.runtime.businessmetrics.emitBusinessMetric
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.collections.get
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest

internal class EndpointResolverAdapter(
    private val config: SageMakerA2IRuntimeClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)

        if (endpoint.attributes.contains(ServiceEndpointOverride)) request.context.emitBusinessMetric(SmithyBusinessMetric.SERVICE_ENDPOINT_OVERRIDE)
        if (endpoint.attributes.contains(AccountIdBasedEndpointAccountId)) request.context.emitBusinessMetric(SmithyBusinessMetric.ACCOUNT_ID_BASED_ENDPOINT)
        if (endpoint.attributes.contains(AwsSigningAttributes.SigningService) && endpoint.attributes[AwsSigningAttributes.SigningService] == "s3express") request.context.emitBusinessMetric(AwsBusinessMetric.S3_EXPRESS_BUCKET)

        return endpoint
    }
}

internal fun resolveEndpointParams(config: SageMakerA2IRuntimeClient.Config, request: ResolveEndpointRequest): SageMakerA2IRuntimeEndpointParameters {
    return SageMakerA2IRuntimeEndpointParameters {
        region = config.region
        bindAwsBuiltins(config, request)
        endpoint = config.endpointUrl?.toString()
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (SageMakerA2IRuntimeEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
)

private fun SageMakerA2IRuntimeEndpointParameters.Builder.bindAwsBuiltins(config: SageMakerA2IRuntimeClient.Config, request: ResolveEndpointRequest) {
    useDualStack = config.useDualStack
    useFips = config.useFips
}
