// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakera2iruntime.serde

import aws.sdk.kotlin.services.sagemakera2iruntime.model.DescribeHumanLoopResponse
import aws.sdk.kotlin.services.sagemakera2iruntime.model.HumanLoopOutput
import aws.sdk.kotlin.services.sagemakera2iruntime.model.HumanLoopStatus
import aws.sdk.kotlin.services.sagemakera2iruntime.model.SageMakerA2IRuntimeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeHumanLoopOperationDeserializer: HttpDeserialize<DescribeHumanLoopResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeHumanLoopResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeHumanLoopError(context, call)
        }
        val builder = DescribeHumanLoopResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeHumanLoopOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeHumanLoopError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerA2IRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerA2IRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeHumanLoopOperationBody(builder: DescribeHumanLoopResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILURECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureCode"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val FLOWDEFINITIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FlowDefinitionArn"))
    val HUMANLOOPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HumanLoopArn"))
    val HUMANLOOPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HumanLoopName"))
    val HUMANLOOPOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HumanLoopOutput"))
    val HUMANLOOPSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("HumanLoopStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILURECODE_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(FLOWDEFINITIONARN_DESCRIPTOR)
        field(HUMANLOOPARN_DESCRIPTOR)
        field(HUMANLOOPNAME_DESCRIPTOR)
        field(HUMANLOOPOUTPUT_DESCRIPTOR)
        field(HUMANLOOPSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromIso8601(it) }
                FAILURECODE_DESCRIPTOR.index -> builder.failureCode = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                FLOWDEFINITIONARN_DESCRIPTOR.index -> builder.flowDefinitionArn = deserializeString()
                HUMANLOOPARN_DESCRIPTOR.index -> builder.humanLoopArn = deserializeString()
                HUMANLOOPNAME_DESCRIPTOR.index -> builder.humanLoopName = deserializeString()
                HUMANLOOPOUTPUT_DESCRIPTOR.index -> builder.humanLoopOutput = deserializeHumanLoopOutputDocument(deserializer)
                HUMANLOOPSTATUS_DESCRIPTOR.index -> builder.humanLoopStatus = deserializeString().let { HumanLoopStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
