// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakera2iruntime

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.sagemakera2iruntime.auth.DefaultSageMakerA2IRuntimeAuthSchemeProvider
import aws.sdk.kotlin.services.sagemakera2iruntime.auth.SageMakerA2IRuntimeAuthSchemeProvider
import aws.sdk.kotlin.services.sagemakera2iruntime.endpoints.DefaultSageMakerA2IRuntimeEndpointProvider
import aws.sdk.kotlin.services.sagemakera2iruntime.endpoints.SageMakerA2IRuntimeEndpointParameters
import aws.sdk.kotlin.services.sagemakera2iruntime.endpoints.SageMakerA2IRuntimeEndpointProvider
import aws.sdk.kotlin.services.sagemakera2iruntime.model.DeleteHumanLoopRequest
import aws.sdk.kotlin.services.sagemakera2iruntime.model.DeleteHumanLoopResponse
import aws.sdk.kotlin.services.sagemakera2iruntime.model.DescribeHumanLoopRequest
import aws.sdk.kotlin.services.sagemakera2iruntime.model.DescribeHumanLoopResponse
import aws.sdk.kotlin.services.sagemakera2iruntime.model.ListHumanLoopsRequest
import aws.sdk.kotlin.services.sagemakera2iruntime.model.ListHumanLoopsResponse
import aws.sdk.kotlin.services.sagemakera2iruntime.model.StartHumanLoopRequest
import aws.sdk.kotlin.services.sagemakera2iruntime.model.StartHumanLoopResponse
import aws.sdk.kotlin.services.sagemakera2iruntime.model.StopHumanLoopRequest
import aws.sdk.kotlin.services.sagemakera2iruntime.model.StopHumanLoopResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SageMaker A2I Runtime"
public const val SdkVersion: String = "0.36.0-beta"

/**
 * Amazon Augmented AI (Amazon A2I) adds the benefit of human judgment to any machine learning application. When an AI application can't evaluate data with a high degree of confidence, human reviewers can take over. This human review is called a human review workflow. To create and start a human review workflow, you need three resources: a *worker task template*, a *flow definition*, and a *human loop*.
 *
 * For information about these resources and prerequisites for using Amazon A2I, see [Get Started with Amazon Augmented AI](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-getting-started.html) in the Amazon SageMaker Developer Guide.
 *
 * This API reference includes information about API actions and data types that you can use to interact with Amazon A2I programmatically. Use this guide to:
 * + Start a human loop with the `StartHumanLoop` operation when using Amazon A2I with a *custom task type*. To learn more about the difference between custom and built-in task types, see [Use Task Types ](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-task-types-general.html). To learn how to start a human loop using this API, see [Create and Start a Human Loop for a Custom Task Type ](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-start-human-loop.html#a2i-instructions-starthumanloop) in the Amazon SageMaker Developer Guide.
 * + Manage your human loops. You can list all human loops that you have created, describe individual human loops, and stop and delete human loops. To learn more, see [Monitor and Manage Your Human Loop ](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-monitor-humanloop-results.html) in the Amazon SageMaker Developer Guide.
 *
 * Amazon A2I integrates APIs from various AWS services to create and start human review workflows for those services. To learn how Amazon A2I uses these APIs, see [Use APIs in Amazon A2I](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-api-references.html) in the Amazon SageMaker Developer Guide.
 */
public interface SageMakerA2IRuntimeClient : SdkClient {
    /**
     * SageMakerA2IRuntimeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SageMakerA2IRuntimeClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "SageMakerA2IRuntime",
                "SAGEMAKER_A2I_RUNTIME",
                "sagemaker_a2i_runtime",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SageMakerA2IRuntimeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SageMakerA2IRuntimeClient = DefaultSageMakerA2IRuntimeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SageMakerA2IRuntimeEndpointProvider = builder.endpointProvider ?: DefaultSageMakerA2IRuntimeEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SageMakerA2IRuntimeAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSageMakerA2IRuntimeAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SageMaker A2I Runtime"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SageMakerA2IRuntimeEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SageMakerA2IRuntimeAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified human loop for a flow definition.
     *
     * If the human loop was deleted, this operation will return a `ResourceNotFoundException`.
     */
    public suspend fun deleteHumanLoop(input: DeleteHumanLoopRequest): DeleteHumanLoopResponse

    /**
     * Returns information about the specified human loop. If the human loop was deleted, this operation will return a `ResourceNotFoundException` error.
     */
    public suspend fun describeHumanLoop(input: DescribeHumanLoopRequest): DescribeHumanLoopResponse

    /**
     * Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not be included.
     */
    public suspend fun listHumanLoops(input: ListHumanLoopsRequest): ListHumanLoopsResponse

    /**
     * Starts a human loop, provided that at least one activation condition is met.
     */
    public suspend fun startHumanLoop(input: StartHumanLoopRequest): StartHumanLoopResponse

    /**
     * Stops the specified human loop.
     */
    public suspend fun stopHumanLoop(input: StopHumanLoopRequest): StopHumanLoopResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SageMakerA2IRuntimeClient.withConfig(block: SageMakerA2IRuntimeClient.Config.Builder.() -> Unit): SageMakerA2IRuntimeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSageMakerA2IRuntimeClient(newConfig)
}

/**
 * Deletes the specified human loop for a flow definition.
 *
 * If the human loop was deleted, this operation will return a `ResourceNotFoundException`.
 */
public suspend inline fun SageMakerA2IRuntimeClient.deleteHumanLoop(crossinline block: DeleteHumanLoopRequest.Builder.() -> Unit): DeleteHumanLoopResponse = deleteHumanLoop(DeleteHumanLoopRequest.Builder().apply(block).build())

/**
 * Returns information about the specified human loop. If the human loop was deleted, this operation will return a `ResourceNotFoundException` error.
 */
public suspend inline fun SageMakerA2IRuntimeClient.describeHumanLoop(crossinline block: DescribeHumanLoopRequest.Builder.() -> Unit): DescribeHumanLoopResponse = describeHumanLoop(DescribeHumanLoopRequest.Builder().apply(block).build())

/**
 * Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not be included.
 */
public suspend inline fun SageMakerA2IRuntimeClient.listHumanLoops(crossinline block: ListHumanLoopsRequest.Builder.() -> Unit): ListHumanLoopsResponse = listHumanLoops(ListHumanLoopsRequest.Builder().apply(block).build())

/**
 * Starts a human loop, provided that at least one activation condition is met.
 */
public suspend inline fun SageMakerA2IRuntimeClient.startHumanLoop(crossinline block: StartHumanLoopRequest.Builder.() -> Unit): StartHumanLoopResponse = startHumanLoop(StartHumanLoopRequest.Builder().apply(block).build())

/**
 * Stops the specified human loop.
 */
public suspend inline fun SageMakerA2IRuntimeClient.stopHumanLoop(crossinline block: StopHumanLoopRequest.Builder.() -> Unit): StopHumanLoopResponse = stopHumanLoop(StopHumanLoopRequest.Builder().apply(block).build())
