// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.AgentVersion
import aws.sdk.kotlin.services.sagemaker.model.DeviceStats
import aws.sdk.kotlin.services.sagemaker.model.EdgeModelStat
import aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.GetDeviceFleetReportResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetDeviceFleetReportOperationDeserializer: HttpDeserialize<GetDeviceFleetReportResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDeviceFleetReportResponse {
        if (!response.status.isSuccess()) {
            throwGetDeviceFleetReportError(context, response)
        }
        val builder = GetDeviceFleetReportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDeviceFleetReportOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDeviceFleetReportError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeviceFleetReportOperationBody(builder: GetDeviceFleetReportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AgentVersions"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DEVICEFLEETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceFleetArn"))
    val DEVICEFLEETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceFleetName"))
    val DEVICESTATS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceStats"))
    val MODELSTATS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ModelStats"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val REPORTGENERATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ReportGenerated"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTVERSIONS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DEVICEFLEETARN_DESCRIPTOR)
        field(DEVICEFLEETNAME_DESCRIPTOR)
        field(DEVICESTATS_DESCRIPTOR)
        field(MODELSTATS_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(REPORTGENERATED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTVERSIONS_DESCRIPTOR.index -> builder.agentVersions =
                    deserializer.deserializeList(AGENTVERSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<AgentVersion>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAgentVersionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DEVICEFLEETARN_DESCRIPTOR.index -> builder.deviceFleetArn = deserializeString()
                DEVICEFLEETNAME_DESCRIPTOR.index -> builder.deviceFleetName = deserializeString()
                DEVICESTATS_DESCRIPTOR.index -> builder.deviceStats = deserializeDeviceStatsDocument(deserializer)
                MODELSTATS_DESCRIPTOR.index -> builder.modelStats =
                    deserializer.deserializeList(MODELSTATS_DESCRIPTOR) {
                        val col0 = mutableListOf<EdgeModelStat>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEdgeModelStatDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeEdgeOutputConfigDocument(deserializer)
                REPORTGENERATED_DESCRIPTOR.index -> builder.reportGenerated = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
